/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.vector.calibrate;

import io.github.dsheirer.dsp.am.AmDemodulatorCalibration;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.calibration.VectorCalibrationPreference;
import io.github.dsheirer.vector.calibrate.Calibration;
import io.github.dsheirer.vector.calibrate.CalibrationException;
import io.github.dsheirer.vector.calibrate.CalibrationType;
import io.github.dsheirer.vector.calibrate.Implementation;
import io.github.dsheirer.vector.calibrate.airspy.AirspySampleConverterCalibration;
import io.github.dsheirer.vector.calibrate.airspy.AirspyUnpackedCalibration;
import io.github.dsheirer.vector.calibrate.airspy.AirspyUnpackedInterleavedCalibration;
import io.github.dsheirer.vector.calibrate.demodulator.FmDemodulatorCalibration;
import io.github.dsheirer.vector.calibrate.filter.FirFilterCalibration;
import io.github.dsheirer.vector.calibrate.filter.RealDcRemovalCalibration;
import io.github.dsheirer.vector.calibrate.filter.RealHalfBand11TapFilterCalibration;
import io.github.dsheirer.vector.calibrate.filter.RealHalfBand15TapFilterCalibration;
import io.github.dsheirer.vector.calibrate.filter.RealHalfBand23TapFilterCalibration;
import io.github.dsheirer.vector.calibrate.filter.RealHalfBand63TapFilterCalibration;
import io.github.dsheirer.vector.calibrate.filter.RealHalfBandDefaultFilterCalibration;
import io.github.dsheirer.vector.calibrate.gain.ComplexGainCalibration;
import io.github.dsheirer.vector.calibrate.gain.ComplexGainControlCalibration;
import io.github.dsheirer.vector.calibrate.magnitude.MagnitudeCalibration;
import io.github.dsheirer.vector.calibrate.mixer.ComplexMixerCalibration;
import io.github.dsheirer.vector.calibrate.oscillator.ComplexOscillatorCalibration;
import io.github.dsheirer.vector.calibrate.oscillator.RealOscillatorCalibration;
import io.github.dsheirer.vector.calibrate.window.WindowCalibration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CalibrationManager {
    private static final Logger mLog = LoggerFactory.getLogger(CalibrationManager.class);
    private Map<CalibrationType, Calibration> mCalibrationMap = new HashMap<CalibrationType, Calibration>();
    private static CalibrationManager sInstance;
    private static VectorCalibrationPreference sVectorCalibrationPreference;

    private CalibrationManager() {
    }

    public static CalibrationManager getInstance(UserPreferences userPreferences) {
        if (sVectorCalibrationPreference == null) {
            sVectorCalibrationPreference = userPreferences.getVectorCalibrationPreference();
        }
        return CalibrationManager.getInstance();
    }

    public static CalibrationManager getInstance() {
        if (sInstance == null) {
            if (sVectorCalibrationPreference == null) {
                sVectorCalibrationPreference = new UserPreferences().getVectorCalibrationPreference();
            }
            sInstance = new CalibrationManager();
            sInstance.add(new AirspySampleConverterCalibration());
            sInstance.add(new AirspyUnpackedCalibration());
            sInstance.add(new AirspyUnpackedInterleavedCalibration());
            sInstance.add(new AmDemodulatorCalibration());
            sInstance.add(new ComplexGainCalibration());
            sInstance.add(new ComplexGainControlCalibration());
            sInstance.add(new ComplexOscillatorCalibration());
            sInstance.add(new ComplexMixerCalibration());
            sInstance.add(new FirFilterCalibration());
            sInstance.add(new FmDemodulatorCalibration());
            sInstance.add(new MagnitudeCalibration());
            sInstance.add(new RealDcRemovalCalibration());
            sInstance.add(new RealHalfBand11TapFilterCalibration());
            sInstance.add(new RealHalfBand15TapFilterCalibration());
            sInstance.add(new RealHalfBand23TapFilterCalibration());
            sInstance.add(new RealHalfBand63TapFilterCalibration());
            sInstance.add(new RealHalfBandDefaultFilterCalibration());
            sInstance.add(new RealOscillatorCalibration());
            sInstance.add(new WindowCalibration());
        }
        return sInstance;
    }

    private void add(Calibration calibration) {
        if (this.mCalibrationMap.containsKey((Object)calibration.getType())) {
            throw new IllegalStateException("Calibration Type [" + String.valueOf((Object)calibration.getType()) + "] is already registered for [" + String.valueOf(this.mCalibrationMap.get((Object)calibration.getType()).getClass()));
        }
        this.mCalibrationMap.put(calibration.getType(), calibration);
    }

    public List<CalibrationType> getCalibrationTypes() {
        return List.copyOf(this.mCalibrationMap.keySet());
    }

    public Calibration getCalibration(CalibrationType type) {
        return this.mCalibrationMap.get((Object)type);
    }

    public Implementation getImplementation(CalibrationType type) {
        if (sVectorCalibrationPreference.isVectorEnabled()) {
            Calibration calibration = this.getCalibration(type);
            if (calibration != null) {
                return calibration.getImplementation();
            }
            return Implementation.UNCALIBRATED;
        }
        return Implementation.SCALAR;
    }

    public boolean isCalibrated() {
        for (Calibration calibration : this.mCalibrationMap.values()) {
            if (calibration.isCalibrated()) continue;
            return false;
        }
        return true;
    }

    public void reset() {
        for (Calibration calibration : this.mCalibrationMap.values()) {
            calibration.reset();
        }
    }

    public void reset(CalibrationType type) {
        Calibration calibration = this.mCalibrationMap.get((Object)type);
        if (calibration != null) {
            calibration.reset();
        }
    }

    public void calibrate() throws CalibrationException {
        List<Calibration> uncalibrated = this.getUncalibrated();
        if (uncalibrated.isEmpty()) {
            mLog.info("No additional calibrations are required at this time.");
        } else {
            mLog.info("Calibrating software for optimal performance on this computer.");
            mLog.info("*** Please be patient, this may take a few minutes ***");
            int calibrationCounter = 0;
            for (Calibration calibration : uncalibrated) {
                if (calibration.isCalibrated()) continue;
                mLog.info("Calibrating [" + ++calibrationCounter + " of " + uncalibrated.size() + "] Type: " + String.valueOf((Object)calibration.getType()));
                calibration.calibrate();
            }
            mLog.info("Calibration Complete!");
        }
    }

    public List<Calibration> getUncalibrated() {
        ArrayList<Calibration> uncalibrated = new ArrayList<Calibration>();
        for (Calibration calibration : this.mCalibrationMap.values()) {
            if (calibration.isCalibrated()) continue;
            uncalibrated.add(calibration);
        }
        Collections.sort(uncalibrated, Comparator.comparing(Calibration::getType));
        return uncalibrated;
    }

    public static void main(String[] args) {
        CalibrationManager manager = CalibrationManager.getInstance();
        manager.reset(CalibrationType.WINDOW);
        if (!manager.isCalibrated()) {
            try {
                manager.calibrate();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.out.println("Complete");
    }
}

