/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.util;

import java.util.EnumSet;
import java.util.Locale;

public enum OSType {
    LINUX_X86_32,
    LINUX_X86_64,
    LINUX_ARM_32,
    LINUX_AARCH_64,
    OSX_AARCH_64,
    OSX_X86_64,
    WINDOWS_AARCH_64,
    WINDOWS_X86_32,
    WINDOWS_X86_64,
    UNKNOWN;

    public static EnumSet<OSType> LINUX_TYPES;
    public static EnumSet<OSType> OSX_TYPES;
    public static EnumSet<OSType> WINDOWS_TYPES;

    public boolean isWindows() {
        return WINDOWS_TYPES.contains((Object)this);
    }

    public boolean isLinux() {
        return LINUX_TYPES.contains((Object)this);
    }

    public boolean isOsx() {
        return OSX_TYPES.contains((Object)this);
    }

    public static OSType getCurrentOSType() {
        String os = System.getProperty("os.name", "unknown").toLowerCase(Locale.ENGLISH);
        String arch = System.getProperty("os.arch");
        if (os.contains("win")) {
            if (arch.contains("amd64")) {
                return WINDOWS_X86_64;
            }
            if (arch.contains("x86")) {
                return WINDOWS_X86_32;
            }
            if (arch.contains("aarch64")) {
                return WINDOWS_AARCH_64;
            }
        }
        if (os.contains("mac") || os.contains("darwin") || os.contains("osx")) {
            if (arch.contains("amd64")) {
                return OSX_X86_64;
            }
            if (arch.contains("aarch64")) {
                return OSX_AARCH_64;
            }
        }
        if (os.contains("nux") || os.contains("nix") || os.contains("aix")) {
            if (arch.contains("amd64")) {
                return LINUX_X86_64;
            }
            if (arch.contains("x86")) {
                return LINUX_X86_32;
            }
            if (arch.contains("aarch64")) {
                return LINUX_AARCH_64;
            }
            if (arch.contains("arm")) {
                return LINUX_ARM_32;
            }
        }
        return UNKNOWN;
    }

    static {
        LINUX_TYPES = EnumSet.of(LINUX_X86_32, LINUX_X86_64, LINUX_ARM_32, LINUX_AARCH_64);
        OSX_TYPES = EnumSet.of(OSX_AARCH_64, OSX_X86_64);
        WINDOWS_TYPES = EnumSet.of(WINDOWS_AARCH_64, WINDOWS_X86_32, WINDOWS_X86_64);
    }
}

