/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.util;

public class ByteUtil {
    public static int toInteger(byte[] bytes, int offset) {
        if (bytes == null || bytes.length < offset + 4) {
            throw new IllegalArgumentException("Conversion to integer requires byte array with at least 4 bytes - length:" + bytes.length + " offset:" + offset);
        }
        int value = (bytes[offset + 3] & 0xFF) << 24;
        value += (bytes[offset + 2] & 0xFF) << 16;
        value += (bytes[offset + 1] & 0xFF) << 8;
        return value += bytes[offset] & 0xFF;
    }

    public static String toHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format("%02X", b));
        }
        return sb.toString();
    }
}

