/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum.menu;

import io.github.dsheirer.spectrum.SpectralDisplayAdjuster;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AveragingItem
extends JSlider
implements ChangeListener {
    private static final long serialVersionUID = 1L;
    private SpectralDisplayAdjuster mAdjuster;
    private int mDefaultValue;

    public AveragingItem(SpectralDisplayAdjuster adjuster, int defaultValue) {
        super(0, 1, 20, adjuster.getAveraging());
        this.mDefaultValue = defaultValue;
        this.mAdjuster = adjuster;
        this.setMajorTickSpacing(5);
        this.setMinorTickSpacing(1);
        this.setPaintTicks(true);
        this.setPaintLabels(true);
        this.addChangeListener(this);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent event) {
                if (event.getClickCount() == 2) {
                    AveragingItem.this.setValue(AveragingItem.this.mDefaultValue);
                }
            }

            @Override
            public void mouseReleased(MouseEvent arg0) {
            }

            @Override
            public void mousePressed(MouseEvent arg0) {
            }

            @Override
            public void mouseExited(MouseEvent arg0) {
            }

            @Override
            public void mouseEntered(MouseEvent arg0) {
            }
        });
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        int value = ((JSlider)event.getSource()).getValue();
        this.mAdjuster.setAveraging(value);
    }
}

