/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.OverflowableTransferQueue;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.LinkedTransferQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OverflowableBufferStream<T extends INativeBuffer>
extends OverflowableTransferQueue<T> {
    private static final Logger mLog = LoggerFactory.getLogger(OverflowableBufferStream.class);
    private int mFlushCount = 0;
    private Iterator<InterleavedComplexSamples> mCurrentNativeBufferIterator;
    private InterleavedComplexSamples mCurrentBuffer;
    private int mCurrentBufferPointer = 0;
    private FloatBuffer mFloatBuffer;
    private LinkedList<T> mBufferList = new LinkedList();
    private int mBufferFetchLimit;

    public OverflowableBufferStream(int maxSize, int resetThreshold, int arraySize) {
        super(maxSize, resetThreshold);
        this.mFloatBuffer = FloatBuffer.allocate(arraySize);
        this.mBufferFetchLimit = maxSize - resetThreshold;
    }

    public float[] get(int sampleCount, int overlap) throws IOException {
        if (overlap >= sampleCount) {
            throw new IllegalArgumentException("Overlap must be less than the requested sample count");
        }
        if (this.mCurrentBuffer == null) {
            this.getNextBuffer();
        }
        if (this.mFloatBuffer.capacity() != sampleCount) {
            this.mFloatBuffer = FloatBuffer.allocate(sampleCount);
        }
        while (this.mFloatBuffer.hasRemaining()) {
            int available = this.mCurrentBuffer.samples().length - this.mCurrentBufferPointer;
            if (available <= 0) {
                this.getNextBuffer();
                continue;
            }
            int toCopy = this.mFloatBuffer.remaining();
            if (available < toCopy) {
                toCopy = available;
            }
            if (toCopy <= 0) continue;
            this.mFloatBuffer.put(this.mCurrentBuffer.samples(), this.mCurrentBufferPointer, toCopy);
            this.mCurrentBufferPointer += toCopy;
        }
        this.mFloatBuffer.rewind();
        float[] samples = new float[sampleCount];
        this.mFloatBuffer.get(samples);
        this.mFloatBuffer.clear();
        if (overlap > 0) {
            this.mFloatBuffer.put(samples, samples.length - overlap, overlap);
        }
        try {
            this.performFlush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mFlushCount = 0;
        return samples;
    }

    private void performFlush() throws IOException {
        while (this.mFlushCount > 0) {
            int available = this.mCurrentBuffer.samples().length - this.mCurrentBufferPointer;
            if (available <= this.mFlushCount) {
                this.mFlushCount -= available;
                this.getNextBuffer();
                continue;
            }
            this.mCurrentBufferPointer += this.mFlushCount;
            this.mFlushCount = 0;
        }
    }

    public void flush(int sampleCount) {
        this.mFlushCount += sampleCount;
    }

    private void getNextBuffer() throws IOException {
        if (this.mCurrentNativeBufferIterator == null) {
            INativeBuffer buffer;
            if (this.mBufferList.isEmpty()) {
                this.drainTo(this.mBufferList, this.mBufferFetchLimit);
            }
            if (!this.mBufferList.isEmpty() && (buffer = (INativeBuffer)this.mBufferList.poll()) != null) {
                this.mCurrentNativeBufferIterator = buffer.iteratorInterleaved();
            }
        }
        if (this.mCurrentNativeBufferIterator != null && !this.mCurrentNativeBufferIterator.hasNext()) {
            this.mCurrentNativeBufferIterator = null;
            this.getNextBuffer();
            return;
        }
        if (this.mCurrentNativeBufferIterator == null || !this.mCurrentNativeBufferIterator.hasNext()) {
            this.mCurrentBuffer = null;
            throw new IOException("Buffer queue is empty");
        }
        this.mCurrentBuffer = this.mCurrentNativeBufferIterator.next();
        this.mCurrentBufferPointer = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        LinkedTransferQueue linkedTransferQueue = this.mQueue;
        synchronized (linkedTransferQueue) {
            this.mQueue.clear();
            this.mCounter.set(0);
            this.mOverflow.set(false);
        }
    }
}

