/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.spectrum;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.controller.NamingThreadFactory;
import io.github.dsheirer.dsp.window.WindowFactory;
import io.github.dsheirer.dsp.window.WindowType;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.spectrum.DFTSize;
import io.github.dsheirer.spectrum.IDFTWidthChangeProcessor;
import io.github.dsheirer.spectrum.NativeBufferManager;
import io.github.dsheirer.spectrum.converter.DFTResultsConverter;
import java.io.IOException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jtransforms.fft.FloatFFT_1D;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexDftProcessor<T extends INativeBuffer>
implements Listener<T>,
IDFTWidthChangeProcessor {
    private static final Logger mLog = LoggerFactory.getLogger(ComplexDftProcessor.class);
    private static final String FRAME_RATE_PROPERTY = "spectral.display.frame.rate";
    private WindowType mWindowType = WindowType.BLACKMAN_HARRIS_7;
    private float[] mWindow;
    private DFTSize mDFTSize = DFTSize.FFT04096;
    private DFTSize mNewDFTSize = DFTSize.FFT04096;
    private FloatFFT_1D mFFT = new FloatFFT_1D((long)this.mDFTSize.getSize());
    private int mFrameRate;
    private AtomicBoolean mRunning = new AtomicBoolean();
    private ScheduledFuture<?> mProcessorTaskHandle;
    private ScheduledExecutorService mExecutorService = Executors.newSingleThreadScheduledExecutor(new NamingThreadFactory("sdrtrunk dft processor"));
    private CopyOnWriteArrayList<DFTResultsConverter> mListeners = new CopyOnWriteArrayList();
    private NativeBufferManager mDftBufferManager = new NativeBufferManager(this.mDFTSize.getSize() * 2);
    private float[] mPreviousSamples = new float[this.mDFTSize.getSize() * 2];

    public ComplexDftProcessor() {
        this.mFrameRate = SystemProperties.getInstance().get(FRAME_RATE_PROPERTY, 20);
        this.setWindowType(this.mWindowType);
        this.start();
    }

    public void dispose() {
        this.stop();
        this.mListeners.clear();
        this.mWindow = null;
    }

    public WindowType getWindowType() {
        return this.mWindowType;
    }

    public void setWindowType(WindowType windowType) {
        this.mWindowType = windowType;
        this.updateWindow();
    }

    private void updateWindow() {
        this.mWindow = WindowFactory.getWindow(this.mWindowType, this.mDFTSize.getSize() * 2);
    }

    @Override
    public void setDFTSize(DFTSize size) {
        this.mNewDFTSize = size;
    }

    @Override
    public DFTSize getDFTSize() {
        return this.mDFTSize;
    }

    public int getFrameRate() {
        return this.mFrameRate;
    }

    public void setFrameRate(int framesPerSecond) {
        if (framesPerSecond < 1 || framesPerSecond > 1000) {
            throw new IllegalArgumentException("DFTProcessor cannot run more than 1000 times per second -- requested setting:" + framesPerSecond);
        }
        this.mFrameRate = framesPerSecond;
        SystemProperties.getInstance().set(FRAME_RATE_PROPERTY, this.mFrameRate);
        this.restart();
    }

    public void start() {
        if (this.mProcessorTaskHandle == null) {
            int initialDelay = 0;
            int period = 1000 / this.mFrameRate;
            this.mProcessorTaskHandle = this.mExecutorService.scheduleAtFixedRate(new DFTCalculationTask(), initialDelay, period, TimeUnit.MILLISECONDS);
        }
    }

    public void stop() {
        if (this.mProcessorTaskHandle != null) {
            this.mProcessorTaskHandle.cancel(false);
            this.mProcessorTaskHandle = null;
        }
    }

    public boolean isRunning() {
        return this.mProcessorTaskHandle != null;
    }

    public void restart() {
        this.stop();
        this.start();
    }

    @Override
    public void receive(T buffer) {
        this.mDftBufferManager.add(buffer);
    }

    private void calculate() {
        this.dispatch(this.mPreviousSamples);
        try {
            float[] samples = this.mDftBufferManager.get(this.mDFTSize.getSize());
            WindowFactory.apply(this.mWindow, samples);
            this.mFFT.complexForward(samples);
            this.mPreviousSamples = samples;
        }
        catch (IOException samples) {
        }
        catch (Exception e) {
            if (e instanceof InterruptedException) {
                mLog.info("FFT Library interrupted exception - this is normal during application shutdown");
            }
            mLog.error("Error while calculating FFT results", (Throwable)e);
        }
    }

    private void dispatch(float[] results) {
        for (DFTResultsConverter mListener : this.mListeners) {
            mListener.receive(results);
        }
    }

    public void addConverter(DFTResultsConverter listener) {
        this.mListeners.add(listener);
    }

    private void checkFFTSize() {
        if (this.mNewDFTSize.getSize() != this.mDFTSize.getSize()) {
            this.mDFTSize = this.mNewDFTSize;
            this.updateWindow();
            this.mFFT = new FloatFFT_1D((long)this.mDFTSize.getSize());
        }
    }

    public void clearBuffer() {
        this.mDftBufferManager.clear();
    }

    private class DFTCalculationTask
    implements Runnable {
        private DFTCalculationTask() {
        }

        @Override
        public void run() {
            try {
                if (ComplexDftProcessor.this.mRunning.compareAndSet(false, true)) {
                    ComplexDftProcessor.this.checkFFTSize();
                    ComplexDftProcessor.this.calculate();
                    ComplexDftProcessor.this.mRunning.set(false);
                }
            }
            catch (Exception e) {
                mLog.error("error during dft processor calculation task", (Throwable)e);
            }
        }
    }
}

