/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.wave;

import io.github.dsheirer.buffer.FloatNativeBuffer;
import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.ConversionUtils;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.SampleType;
import io.github.dsheirer.source.IControllableFileSource;
import io.github.dsheirer.source.IFrameLocationListener;
import io.github.dsheirer.source.Source;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.util.ThreadPool;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComplexWaveSource
extends Source
implements IControllableFileSource,
AutoCloseable {
    private static final Logger mLog = LoggerFactory.getLogger(ComplexWaveSource.class);
    private IFrameLocationListener mFrameLocationListener;
    private int mBufferSampleCount = 65536;
    private int mBytesPerFrame;
    private int mFrameCounter = 0;
    private long mFrequency = 0L;
    private Listener<INativeBuffer> mListener;
    private AudioInputStream mInputStream;
    private File mFile;
    private boolean mAutoReplay;
    private ScheduledFuture<?> mReplayController;

    public ComplexWaveSource(File file, boolean autoReplay) throws IOException {
        if (file == null || !file.exists() || !ComplexWaveSource.supports(file)) {
            throw new IOException("Empty or null file");
        }
        if (!ComplexWaveSource.supports(file)) {
            throw new IOException("Unsupported file format");
        }
        this.mFile = file;
        this.mAutoReplay = autoReplay;
    }

    public ComplexWaveSource(File file) throws IOException {
        this(file, false);
    }

    @Override
    public SampleType getSampleType() {
        return SampleType.COMPLEX;
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
    }

    @Override
    public void removeSourceEventListener() {
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return null;
    }

    @Override
    public void reset() {
        this.stop();
        this.mFrameCounter = 0;
        this.start();
    }

    public int getBufferSampleCount() {
        return this.mBufferSampleCount;
    }

    @Override
    public void start() {
        if (this.mInputStream == null) {
            try {
                this.open();
            }
            catch (Exception e) {
                mLog.error("Error", (Throwable)e);
            }
        }
        if (this.mAutoReplay) {
            double sampleRate = this.getSampleRate();
            double buffersPerSecond = sampleRate / (double)this.mBufferSampleCount;
            long intervalMilliseconds = (long)(1000.0 / buffersPerSecond);
            ReplayController r = new ReplayController(this.mBufferSampleCount);
            this.mReplayController = ThreadPool.SCHEDULED.scheduleAtFixedRate(r, 0L, intervalMilliseconds, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.mReplayController != null) {
                this.mReplayController.cancel(true);
            }
            this.close();
        }
        catch (IOException e) {
            mLog.error("Error stopping complex wave source");
        }
    }

    @Override
    public long getFrameCount() throws IOException {
        return 0L;
    }

    @Override
    public double getSampleRate() {
        if (this.mInputStream != null) {
            return this.mInputStream.getFormat().getSampleRate();
        }
        return 0.0;
    }

    @Override
    public long getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(long frequency) {
        this.mFrequency = frequency;
    }

    @Override
    public void close() throws IOException {
        if (this.mInputStream != null) {
            this.mInputStream.close();
            this.mInputStream = null;
        }
    }

    @Override
    public void open() throws IOException, UnsupportedAudioFileException {
        if (this.mInputStream == null) {
            this.mInputStream = AudioSystem.getAudioInputStream(this.mFile);
            AudioFormat format = this.mInputStream.getFormat();
            this.mBytesPerFrame = format.getFrameSize();
            if (format.getChannels() != 2 || format.getSampleSizeInBits() != 16) {
                throw new IOException("Unsupported Wave Format - EXPECTED: 2 channels 16-bit samples FOUND: " + this.mInputStream.getFormat().getChannels() + " channels " + this.mInputStream.getFormat().getSampleSizeInBits() + "-bit samples");
            }
            this.broadcast(0);
        }
    }

    @Override
    public void next(int frames) throws IOException {
        this.next(frames, true);
    }

    @Override
    public void next(int frames, boolean broadcast) throws IOException {
        if (this.mInputStream != null) {
            byte[] buffer = new byte[this.mBytesPerFrame * frames];
            int samplesRead = this.mInputStream.read(buffer);
            this.mFrameCounter += samplesRead;
            this.broadcast(this.mFrameCounter);
            if (broadcast && this.mListener != null) {
                if (samplesRead < 0) {
                    throw new IOException("End of file reached");
                }
                if (samplesRead < buffer.length) {
                    buffer = Arrays.copyOf(buffer, samplesRead);
                }
                float[] samples = ConversionUtils.convertFromSigned16BitSamples(buffer);
                this.mListener.receive(new FloatNativeBuffer(samples, System.currentTimeMillis(), this.mInputStream.getFormat().getSampleRate() / 1000.0f));
            }
        }
    }

    public void setListener(Listener<INativeBuffer> listener) {
        this.mListener = listener;
    }

    public void removeListener(Listener<INativeBuffer> listener) {
        this.mListener = null;
    }

    @Override
    public File getFile() {
        return this.mFile;
    }

    private void broadcast(int byteLocation) {
        int frameLocation = byteLocation / this.mBytesPerFrame;
        if (this.mFrameLocationListener != null) {
            this.mFrameLocationListener.frameLocationUpdated(frameLocation);
        }
    }

    @Override
    public void setListener(IFrameLocationListener listener) {
        this.mFrameLocationListener = listener;
    }

    @Override
    public void removeListener(IFrameLocationListener listener) {
        this.mFrameLocationListener = null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean supports(File file) {
        try (AudioInputStream ais = AudioSystem.getAudioInputStream(file);){
            AudioFormat format = ais.getFormat();
            if (format.getChannels() != 2) return false;
            if (format.getSampleSizeInBits() != 16) return false;
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public class ReplayController
    implements Runnable {
        private double mFramesPerInterval;
        private int mFramesRead;
        private int mIntervals;

        public ReplayController(double framesPerInterval) {
            this.mFramesPerInterval = framesPerInterval;
        }

        @Override
        public void run() {
            ++this.mIntervals;
            int framesToRead = (int)FastMath.floor((double)((double)this.mIntervals * this.mFramesPerInterval - (double)this.mFramesRead));
            try {
                ComplexWaveSource.this.next(framesToRead, true);
                this.mFramesRead += framesToRead;
            }
            catch (IOException ioe) {
                mLog.debug("End of Recording - looping [" + ioe.getLocalizedMessage() + "]");
                ComplexWaveSource.this.reset();
            }
        }
    }
}

