/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.ui;

import io.github.dsheirer.playlist.PlaylistManager;
import io.github.dsheirer.properties.SystemProperties;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerEvent;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.ui.DiscoveredTunerModel;
import io.github.dsheirer.spectrum.SpectralDisplayPanel;
import io.github.dsheirer.spectrum.SpectrumFrame;
import io.github.dsheirer.util.SwingUtils;
import io.github.dsheirer.util.ThreadPool;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunerSpectralDisplayManager
implements Listener<TunerEvent> {
    private Logger mLog = LoggerFactory.getLogger(TunerSpectralDisplayManager.class);
    private SpectralDisplayPanel mSpectralDisplayPanel;
    private PlaylistManager mPlaylistManager;
    private SettingsManager mSettingsManager;
    private DiscoveredTunerModel mDiscoveredTunerModel;

    public TunerSpectralDisplayManager(SpectralDisplayPanel panel, PlaylistManager playlistManager, SettingsManager settingsManager, DiscoveredTunerModel discoveredTunerModel) {
        this.mSpectralDisplayPanel = panel;
        this.mPlaylistManager = playlistManager;
        this.mSettingsManager = settingsManager;
        this.mDiscoveredTunerModel = discoveredTunerModel;
    }

    public Tuner showFirstTuner() {
        if (SystemProperties.getInstance().get("spectral.display.enabled", true)) {
            List<DiscoveredTuner> availableTuners = this.mDiscoveredTunerModel.getAvailableTuners();
            for (DiscoveredTuner discoveredTuner : availableTuners) {
                if (!discoveredTuner.hasTuner()) continue;
                this.mSpectralDisplayPanel.showTuner(discoveredTuner.getTuner());
                return discoveredTuner.getTuner();
            }
        }
        return null;
    }

    @Override
    public void receive(TunerEvent event) {
        switch (event.getEvent()) {
            case REQUEST_CLEAR_MAIN_SPECTRAL_DISPLAY: {
                SwingUtils.run(() -> this.mSpectralDisplayPanel.clearTuner());
                break;
            }
            case REQUEST_MAIN_SPECTRAL_DISPLAY: {
                if (!SystemProperties.getInstance().get("spectral.display.enabled", true)) break;
                SwingUtils.run(() -> this.mSpectralDisplayPanel.showTuner(event.getTuner()));
                break;
            }
            case REQUEST_NEW_SPECTRAL_DISPLAY: {
                SpectrumFrame frame = new SpectrumFrame(this.mPlaylistManager, this.mSettingsManager, this.mDiscoveredTunerModel, event.getTuner());
                SwingUtils.run(() -> frame.setVisible(true));
                break;
            }
            case NOTIFICATION_ERROR_STATE: 
            case NOTIFICATION_SHUTTING_DOWN: {
                if (!event.getTuner().equals(this.mSpectralDisplayPanel.getTuner())) break;
                SwingUtils.run(() -> {
                    this.mSpectralDisplayPanel.clearTuner();
                    ThreadPool.SCHEDULED.schedule(() -> SwingUtils.run(() -> this.showFirstTuner()), 1L, TimeUnit.SECONDS);
                });
            }
        }
    }
}

