/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.ui;

import io.github.dsheirer.gui.editor.Editor;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.TunerFactory;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.IDiscoveredTunerStatusListener;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.manager.TunerStatus;
import io.github.dsheirer.source.tuner.ui.EmptyTunerEditor;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import java.awt.LayoutManager;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveredTunerEditor
extends Editor<DiscoveredTuner>
implements IDiscoveredTunerStatusListener {
    private static final long serialVersionUID = 1L;
    private static final Logger mLog = LoggerFactory.getLogger(DiscoveredTunerEditor.class);
    private UserPreferences mUserPreferences;
    private TunerManager mTunerManager;
    private JPanel mEmptyEditor;
    private JPanel mEditor;
    private JScrollPane mEditorScroller;

    public DiscoveredTunerEditor(UserPreferences userPreferences, TunerManager tunerManager) {
        this.mEditor = this.mEmptyEditor = new EmptyTunerEditor();
        this.mUserPreferences = userPreferences;
        this.mTunerManager = tunerManager;
        this.init();
    }

    public void setTunerLockState(boolean locked) {
        JPanel jPanel = this.mEditor;
        if (jPanel instanceof TunerEditor) {
            TunerEditor tunerEditor = (TunerEditor)jPanel;
            tunerEditor.setTunerLockState(locked);
        }
    }

    public void init() {
        this.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
        this.mEditorScroller = new JScrollPane(this.mEditor);
        this.add(this.mEditorScroller);
    }

    @Override
    public void save() {
    }

    @Override
    public void setItem(DiscoveredTuner tuner) {
        JPanel jPanel;
        if (this.hasItem()) {
            ((DiscoveredTuner)this.getItem()).removeTunerStatusListener(this);
        }
        if (this.hasItem() && (jPanel = this.mEditor) instanceof TunerEditor) {
            TunerEditor tunerEditor = (TunerEditor)jPanel;
            tunerEditor.dispose();
        }
        super.setItem(tuner);
        this.mEditorScroller.remove(this.mEditor);
        if (this.hasItem()) {
            this.mEditor = TunerFactory.getEditor(this.mUserPreferences, (DiscoveredTuner)this.getItem(), this.mTunerManager);
            ((DiscoveredTuner)this.getItem()).addTunerStatusListener(this);
        } else {
            this.mEditor = this.mEmptyEditor;
        }
        this.remove(this.mEditorScroller);
        this.mEditorScroller = new JScrollPane(this.mEditor);
        this.add(this.mEditorScroller);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void tunerStatusUpdated(DiscoveredTuner discoveredTuner, TunerStatus previous, TunerStatus current) {
        if (this.hasItem() && ((DiscoveredTuner)this.getItem()).equals(discoveredTuner)) {
            if (current == TunerStatus.REMOVED) {
                this.setItem(null);
            } else {
                this.setItem(discoveredTuner);
            }
        }
    }
}

