/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDuo;

import io.github.dsheirer.eventbus.MyEventBus;
import io.github.dsheirer.gui.preference.PreferenceEditorType;
import io.github.dsheirer.gui.preference.ViewUserPreferenceEditorRequest;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.sdrplay.DiscoveredRspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.RspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspTunerEditor;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.AgcMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.RspDuoAmPort;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.IControlRspDuoTuner1;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.RspDuoTuner1Configuration;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.RspDuoTuner1Controller;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.EnumSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspDuoTuner1Editor
extends RspTunerEditor<RspDuoTuner1Configuration> {
    private static final Logger mLog = LoggerFactory.getLogger(RspDuoTuner1Editor.class);
    private JComboBox<RspSampleRate> mSampleRateCombo;
    private JCheckBox mRfDabNotchCheckBox;
    private JCheckBox mRfNotchCheckBox;
    private JCheckBox mAmNotchCheckBox;
    private JCheckBox mExternalReferenceOutputCheckBox;
    private JComboBox<RspDuoAmPort> mAmPortCombo;
    private JButton mTunerPreferencesButton;

    public RspDuoTuner1Editor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredRspTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        JPanel labelAndButtonPanel = new JPanel();
        labelAndButtonPanel.setLayout((LayoutManager)new MigLayout("insets 0"));
        labelAndButtonPanel.add(this.getTunerIdLabel());
        labelAndButtonPanel.add(this.getTunerPreferencesButton());
        this.add((Component)labelAndButtonPanel, "wrap");
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add(new JLabel("Sample Rate:"));
        this.add(this.getSampleRateCombo(), "wrap");
        this.add(new JLabel("IF AGC Mode:"));
        JPanel gainPanel = new JPanel();
        gainPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow,fill][]", ""));
        gainPanel.add(this.getAgcButton());
        gainPanel.add(this.getGainOverloadButton());
        this.add((Component)gainPanel, "wrap");
        this.add(new JLabel("Gain:"));
        this.add(this.getGainSlider());
        this.add(this.getGainValueLabel());
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel());
        this.add((Component)this.getExternalReferenceOutputCheckBox(), "wrap");
        this.add(new JLabel());
        this.add((Component)this.getAmNotchCheckBox(), "wrap");
        this.add(new JLabel());
        this.add((Component)this.getRfDabNotchCheckBox(), "wrap");
        this.add(new JLabel());
        this.add((Component)this.getRfNotchCheckBox(), "wrap");
        this.add(new JLabel("AM Port:"));
        this.add(this.getAmPortCombo(), "wrap");
    }

    private RspDuoTuner1Controller getTunerController() {
        if (this.hasTuner()) {
            return (RspDuoTuner1Controller)((RspTuner)this.getTuner()).getTunerController();
        }
        return null;
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
        this.getSampleRateCombo().setEnabled(!locked);
        this.updateSampleRateToolTip();
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        this.clearSampleRates();
        if (this.hasTuner()) {
            this.setSampleRates(((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).getSupportedSampleRates());
        }
        this.getSampleRateCombo().setEnabled(this.hasTuner() && !((RspTuner)this.getTuner()).getTunerController().isLockedSampleRate());
        this.getSampleRateCombo().setSelectedItem((Object)(this.hasTuner() ? ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).getSampleRateEnumeration() : null));
        this.updateSampleRateToolTip();
        this.getAgcButton().setEnabled(this.hasTuner());
        if (this.hasTuner()) {
            AgcMode current = ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).getAgcMode();
            this.getAgcButton().setSelected(current == null || current.equals((Object)AgcMode.ENABLE));
            ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).setGainOverloadListener(this);
        }
        this.getGainSlider().setEnabled(this.hasTuner());
        this.getGainValueLabel().setEnabled(this.hasTuner());
        this.getGainSlider().setValue(this.hasTuner() ? ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).getGain() : 0);
        this.getAmPortCombo().setEnabled(this.hasTuner() && !((RspTuner)this.getTuner()).getTunerController().isLockedSampleRate());
        try {
            this.getAmPortCombo().setSelectedItem((Object)(this.hasTuner() ? ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).getAmPort() : null));
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting RSPduo tuner 1 AM Port in editor");
        }
        this.getRfDabNotchCheckBox().setEnabled(this.hasTuner());
        try {
            this.getRfDabNotchCheckBox().setSelected(this.hasTuner() && ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).isRfDabNotch());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting RSPduo tuner 1 RF DAB Notch enabled state in editor");
        }
        this.getRfNotchCheckBox().setEnabled(this.hasTuner());
        try {
            this.getRfNotchCheckBox().setSelected(this.hasTuner() && ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).isRfNotch());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting RSPduo tuner 1 RF Notch enabled state in editor");
        }
        this.getAmNotchCheckBox().setEnabled(this.hasTuner());
        try {
            this.getAmNotchCheckBox().setSelected(this.hasTuner() && ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).isAmNotch());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting RSPduo tuner 1 AM Notch enabled state in editor");
        }
        this.getExternalReferenceOutputCheckBox().setEnabled(this.hasTuner());
        try {
            this.getExternalReferenceOutputCheckBox().setSelected(this.hasTuner() && ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).isExternalReferenceOutput());
        }
        catch (SDRPlayException se) {
            mLog.error("Error setting RSPduo tuner 1 external reference output enabled state in editor");
        }
        this.setLoading(false);
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            ((RspDuoTuner1Configuration)this.getConfiguration()).setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            ((RspDuoTuner1Configuration)this.getConfiguration()).setFrequencyCorrection(value);
            ((RspDuoTuner1Configuration)this.getConfiguration()).setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            ((RspDuoTuner1Configuration)this.getConfiguration()).setSampleRate((RspSampleRate)((Object)this.getSampleRateCombo().getSelectedItem()));
            ((RspDuoTuner1Configuration)this.getConfiguration()).setAmNotch(this.getAmNotchCheckBox().isSelected());
            ((RspDuoTuner1Configuration)this.getConfiguration()).setAmPort(this.getAmPortCombo().getSelectedItem() != null ? (RspDuoAmPort)((Object)this.getAmPortCombo().getSelectedItem()) : null);
            ((RspDuoTuner1Configuration)this.getConfiguration()).setExternalReferenceOutput(this.getExternalReferenceOutputCheckBox().isSelected());
            ((RspDuoTuner1Configuration)this.getConfiguration()).setRfDabNotch(this.getRfDabNotchCheckBox().isSelected());
            ((RspDuoTuner1Configuration)this.getConfiguration()).setRfNotch(this.getRfNotchCheckBox().isSelected());
            ((RspDuoTuner1Configuration)this.getConfiguration()).setGain(this.getGainSlider().getValue());
            ((RspDuoTuner1Configuration)this.getConfiguration()).setAgcMode(this.getAgcButton().isSelected() ? AgcMode.ENABLE : AgcMode.DISABLE);
            this.saveConfiguration();
        }
    }

    private void setSampleRates(EnumSet<RspSampleRate> sampleRates) {
        if (!sampleRates.isEmpty()) {
            for (RspSampleRate sampleRate : sampleRates) {
                this.getSampleRateCombo().addItem(sampleRate);
            }
        }
    }

    private void clearSampleRates() {
        this.getSampleRateCombo().removeAllItems();
    }

    private JComboBox<RspSampleRate> getSampleRateCombo() {
        if (this.mSampleRateCombo == null) {
            this.mSampleRateCombo = new JComboBox();
            this.mSampleRateCombo.setEnabled(false);
            this.mSampleRateCombo.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    RspSampleRate selected = (RspSampleRate)((Object)((Object)this.mSampleRateCombo.getSelectedItem()));
                    try {
                        this.getTunerController().setSampleRate(selected);
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Error setting sample rate for RSPduo tuner 1", (Throwable)se);
                    }
                }
            });
        }
        return this.mSampleRateCombo;
    }

    private JComboBox<RspDuoAmPort> getAmPortCombo() {
        if (this.mAmPortCombo == null) {
            this.mAmPortCombo = new JComboBox<RspDuoAmPort>(RspDuoAmPort.values());
            this.mAmPortCombo.setEnabled(false);
            this.mAmPortCombo.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    RspDuoAmPort selected = (RspDuoAmPort)((Object)((Object)this.mAmPortCombo.getSelectedItem()));
                    try {
                        ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).setAmPort(selected);
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Error setting AM port for RSPduo tuner 1", (Throwable)se);
                    }
                }
            });
        }
        return this.mAmPortCombo;
    }

    private JCheckBox getRfDabNotchCheckBox() {
        if (this.mRfDabNotchCheckBox == null) {
            this.mRfDabNotchCheckBox = new JCheckBox("DAB Broadcast Band Filter (157-235 MHz)");
            this.mRfDabNotchCheckBox.setEnabled(false);
            this.mRfDabNotchCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).setRfDabNotch(this.mRfDabNotchCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSPduo tuner 1 RF DAB notch enabled to " + this.mRfDabNotchCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mRfDabNotchCheckBox;
    }

    private JCheckBox getRfNotchCheckBox() {
        if (this.mRfNotchCheckBox == null) {
            this.mRfNotchCheckBox = new JCheckBox("FM Broadcast Band Filter (78-114 MHz)");
            this.mRfNotchCheckBox.setEnabled(false);
            this.mRfNotchCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).setRfNotch(this.mRfNotchCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSPduo tuner 1 RF notch enabled to " + this.mRfNotchCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mRfNotchCheckBox;
    }

    private JCheckBox getAmNotchCheckBox() {
        if (this.mAmNotchCheckBox == null) {
            this.mAmNotchCheckBox = new JCheckBox("AM Broadcast Band Filter (415-1640 kHz)");
            this.mAmNotchCheckBox.setEnabled(false);
            this.mAmNotchCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).setAmNotch(this.mAmNotchCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSPduo tuner 1 AM notch enabled to " + this.mAmNotchCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mAmNotchCheckBox;
    }

    private JCheckBox getExternalReferenceOutputCheckBox() {
        if (this.mExternalReferenceOutputCheckBox == null) {
            this.mExternalReferenceOutputCheckBox = new JCheckBox("External Reference Output");
            this.mExternalReferenceOutputCheckBox.setEnabled(false);
            this.mExternalReferenceOutputCheckBox.addActionListener(e -> {
                if (this.hasTuner() && !this.isLoading()) {
                    try {
                        ((IControlRspDuoTuner1)this.getTunerController().getControlRsp()).setExternalReferenceOutput(this.mExternalReferenceOutputCheckBox.isSelected());
                        this.save();
                    }
                    catch (SDRPlayException se) {
                        mLog.error("Unable to set RSPduo tuner 1 external reference output notch enabled to " + this.mExternalReferenceOutputCheckBox.isSelected(), (Throwable)se);
                    }
                }
            });
        }
        return this.mExternalReferenceOutputCheckBox;
    }

    private JButton getTunerPreferencesButton() {
        if (this.mTunerPreferencesButton == null) {
            this.mTunerPreferencesButton = new JButton("RSPduo Preferences");
            this.mTunerPreferencesButton.addActionListener(e -> MyEventBus.getGlobalEventBus().post((Object)new ViewUserPreferenceEditorRequest(PreferenceEditorType.SOURCE_TUNERS)));
        }
        return this.mTunerPreferencesButton;
    }

    private void updateSampleRateToolTip() {
        if (this.hasTuner() && ((RspTuner)this.getTuner()).getTunerController().isLockedSampleRate()) {
            this.getSampleRateCombo().setToolTipText("Sample Rate is locked.  Disable decoding channels to unlock.");
        } else if (this.hasTuner()) {
            this.getSampleRateCombo().setToolTipText("Select a sample rate for the tuner");
        } else {
            this.getSampleRateCombo().setToolTipText("No tuner available");
        }
    }
}

