/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDuo;

import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.ControlRspDuoTuner1Master;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.RspDuoTuner1Controller;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.RspDuoTuner2Controller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterSlaveBridge {
    private static final Logger mLog = LoggerFactory.getLogger(MasterSlaveBridge.class);
    private RspDuoTuner1Controller mMaster;
    private RspDuoTuner2Controller mSlave;

    public void setMaster(RspDuoTuner1Controller master) {
        this.mMaster = master;
    }

    public void setSlave(RspDuoTuner2Controller slave) {
        this.mSlave = slave;
        if (this.hasMasterControl()) {
            this.notifySampleRate(this.getMasterControl().getSampleRateEnumeration());
        }
    }

    private ControlRspDuoTuner1Master getMasterControl() {
        Object i;
        if (this.mMaster != null && (i = this.mMaster.getControlRsp()) instanceof ControlRspDuoTuner1Master) {
            ControlRspDuoTuner1Master masterControl = (ControlRspDuoTuner1Master)i;
            return masterControl;
        }
        return null;
    }

    private boolean hasMasterControl() {
        return this.getMasterControl() != null;
    }

    public void startMasterStreamContinuously() {
        if (this.hasMasterControl()) {
            this.getMasterControl().startStreamContinuously();
        }
    }

    public void stopSlave() {
        if (this.mSlave != null) {
            this.mSlave.stop();
            this.mSlave = null;
        }
    }

    public void notifySampleRate(RspSampleRate sampleRate) {
        if (this.mSlave != null) {
            try {
                this.mSlave.setSampleRate(sampleRate);
            }
            catch (SDRPlayException se) {
                mLog.error("Error setting sample rate on RSPduo tuner 2 slave", (Throwable)se);
            }
        }
    }
}

