/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDuo;

import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerFactory;
import io.github.dsheirer.source.tuner.sdrplay.DiscoveredRspTuner;
import io.github.dsheirer.source.tuner.sdrplay.RspTuner;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceInfo;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.IControlRspDuoTuner1;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.MasterSlaveBridge;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.RspDuoTuner1Controller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DiscoveredRspDuoTuner1
extends DiscoveredRspTuner<IControlRspDuoTuner1> {
    private static final Logger mLog = LoggerFactory.getLogger(DiscoveredRspTuner.class);
    public static final String RSP_DUO_ID_PREFIX = "RSPduo Tuner ";
    private MasterSlaveBridge mMasterSlaveBridge;

    public DiscoveredRspDuoTuner1(DeviceInfo deviceInfo, ChannelizerType channelizerType) {
        super(deviceInfo, channelizerType);
    }

    public DiscoveredRspDuoTuner1(DeviceInfo deviceInfo, ChannelizerType channelizerType, MasterSlaveBridge bridge) {
        super(deviceInfo, channelizerType);
        this.mMasterSlaveBridge = bridge;
    }

    @Override
    public void start() {
        if (this.isAvailable() && !this.hasTuner()) {
            try {
                if (this.mMasterSlaveBridge != null) {
                    RspTuner rspTuner;
                    this.mTuner = TunerFactory.getRspDuoTuner(this.getDeviceInfo(), this.getChannelizerType(), this, this.mMasterSlaveBridge);
                    ITunerErrorListener iTunerErrorListener = this.mTuner;
                    if (iTunerErrorListener instanceof RspTuner && (iTunerErrorListener = (rspTuner = (RspTuner)iTunerErrorListener).getRspTunerController()) instanceof RspDuoTuner1Controller) {
                        RspDuoTuner1Controller rspDuoTuner1Controller = (RspDuoTuner1Controller)iTunerErrorListener;
                        this.mMasterSlaveBridge.setMaster(rspDuoTuner1Controller);
                    }
                } else {
                    this.mTuner = TunerFactory.getRspTuner(this.getDeviceInfo(), this.getChannelizerType(), this);
                }
            }
            catch (Exception se) {
                this.setErrorMessage("Tuner unavailable [" + this.getId() + "]");
                this.mTuner = null;
            }
            if (this.hasTuner()) {
                try {
                    this.mTuner.start();
                }
                catch (Exception se) {
                    mLog.error("Error", (Throwable)se);
                    this.setErrorMessage("Error starting tuner [" + this.getId() + "]");
                    this.mTuner = null;
                }
            }
        }
    }

    @Override
    public String getId() {
        return "RSPduo Tuner 1 SER#" + this.getDeviceInfo().getSerialNumber();
    }

    public String getSlaveId() {
        return "RSPduo Tuner 2 SER#" + this.getDeviceInfo().getSerialNumber();
    }
}

