/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.rspDuo;

import io.github.dsheirer.source.tuner.sdrplay.RspSampleRate;
import io.github.dsheirer.source.tuner.sdrplay.api.DeviceSelectionMode;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoDevice;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.ControlRspDuoTuner2;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.MasterSlaveBridge;
import java.util.EnumSet;

public class ControlRspDuoTuner2Slave
extends ControlRspDuoTuner2 {
    private MasterSlaveBridge mMasterSlaveBridge;

    public ControlRspDuoTuner2Slave(RspDuoDevice device, MasterSlaveBridge bridge) {
        super(device);
        this.mMasterSlaveBridge = bridge;
    }

    @Override
    public void startStream() {
        if (this.mMasterSlaveBridge != null) {
            this.mMasterSlaveBridge.startMasterStreamContinuously();
        }
        super.startStream();
    }

    @Override
    public boolean isSlaveMode() {
        return true;
    }

    @Override
    public DeviceSelectionMode getDeviceSelectionMode() {
        return DeviceSelectionMode.SLAVE_TUNER_2;
    }

    @Override
    public EnumSet<RspSampleRate> getSupportedSampleRates() {
        return EnumSet.noneOf(RspSampleRate.class);
    }

    @Override
    public void setSampleRate(RspSampleRate sampleRate) throws SDRPlayException {
        if (!this.hasDevice()) {
            throw new SDRPlayException("Device is not initialized");
        }
        this.mSampleRate = sampleRate;
        ((RspDuoDevice)this.getDevice()).getTuner().setBandwidth(sampleRate.getBandwidth());
        this.getControlParameters().getDecimation().setWideBandSignal(true);
        ((RspDuoDevice)this.getDevice()).setDecimation(sampleRate.getDecimation());
    }

    @Override
    public void setExternalReferenceOutput(boolean enabled) throws SDRPlayException {
    }
}

