/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.device;

import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRplay;
import io.github.dsheirer.source.tuner.sdrplay.api.UpdateReason;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Device;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspTuner;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.control.ControlParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.RspDxDeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.HdrModeBandwidth;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.RspDxAntenna;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.RspDxTunerParameters;

public class RspDxTuner
extends RspTuner<RspDxDeviceParameters, RspDxTunerParameters> {
    public RspDxTuner(Device device, SDRplay sdrplay, TunerSelect tunerSelect, RspDxDeviceParameters deviceParameters, RspDxTunerParameters tunerParameters, ControlParameters controlParameters) {
        super(device, sdrplay, tunerSelect, deviceParameters, tunerParameters, controlParameters);
    }

    public boolean isHdrMode() {
        return ((RspDxDeviceParameters)this.getDeviceParameters()).isHdr();
    }

    public void setHdrMode(boolean enable) throws SDRPlayException {
        ((RspDxDeviceParameters)this.getDeviceParameters()).setHdr(enable);
        this.update(UpdateReason.EXTENSION_RSP_DX_HDR_ENABLE);
    }

    public HdrModeBandwidth getHdrModeBandwidth() {
        return ((RspDxTunerParameters)this.getTunerParameters()).getHdrModeBandwidth();
    }

    public void setHdrModeBandwidth(HdrModeBandwidth bandwidth) throws SDRPlayException {
        ((RspDxTunerParameters)this.getTunerParameters()).setHdrModeBandwidth(bandwidth);
        this.update(UpdateReason.EXTENSION_RSP_DX_HDR_BANDWIDTH);
    }

    public boolean isRfNotch() {
        return ((RspDxDeviceParameters)this.getDeviceParameters()).isRfNotch();
    }

    public void setRfNotch(boolean enable) throws SDRPlayException {
        ((RspDxDeviceParameters)this.getDeviceParameters()).setRfNotch(enable);
        this.update(UpdateReason.EXTENSION_RSP_DX_RF_NOTCH_CONTROL);
    }

    public boolean isRfDabNotch() {
        return ((RspDxDeviceParameters)this.getDeviceParameters()).isRfDabNotch();
    }

    public void setRfDabNotch(boolean enable) throws SDRPlayException {
        ((RspDxDeviceParameters)this.getDeviceParameters()).setRfDabNotch(enable);
        this.update(UpdateReason.EXTENSION_RSP_DX_RF_DAB_NOTCH_CONTROL);
    }

    public boolean isBiasT() {
        return ((RspDxDeviceParameters)this.getDeviceParameters()).isBiasT();
    }

    public void setBiasT(boolean enable) throws SDRPlayException {
        ((RspDxDeviceParameters)this.getDeviceParameters()).setBiasT(enable);
        this.update(UpdateReason.EXTENSION_RSP_DX_BIAS_T_CONTROL);
    }

    public RspDxAntenna getAntenna() {
        return ((RspDxDeviceParameters)this.getDeviceParameters()).getRspDxAntenna();
    }

    public void setAntenna(RspDxAntenna antenna) throws SDRPlayException {
        ((RspDxDeviceParameters)this.getDeviceParameters()).setRspDxAntenna(antenna);
        this.update(UpdateReason.EXTENSION_RSP_DX_ANTENNA_CONTROL);
    }
}

