/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api.device;

import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRplay;
import io.github.dsheirer.source.tuner.sdrplay.api.UpdateReason;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Decimate;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Device;
import io.github.dsheirer.source.tuner.sdrplay.api.device.IDeviceStruct;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoMode;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoTuner;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoTuner1;
import io.github.dsheirer.source.tuner.sdrplay.api.device.RspDuoTuner2;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.RspDuoCompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.device.RspDuoDeviceParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.IfMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.LoMode;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.tuner.RspDuoTunerParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_DeviceT;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspDuoDevice
extends Device<RspDuoCompositeParameters, RspDuoTuner> {
    private static final Logger mLog = LoggerFactory.getLogger(RspDuoDevice.class);
    private RspDuoTuner mTuner;

    RspDuoDevice(SDRplay sdrPlay, IDeviceStruct deviceStruct) {
        super(sdrPlay, deviceStruct);
    }

    @Override
    public RspDuoTuner getTuner() throws SDRPlayException {
        if (!this.isSelected()) {
            throw new SDRPlayException("Device must be selected before accessing the tuner");
        }
        if (this.mTuner == null) {
            this.mTuner = this.getTunerSelect().equals((Object)TunerSelect.TUNER_1) ? new RspDuoTuner1(this, this.getAPI(), (RspDuoDeviceParameters)((RspDuoCompositeParameters)this.getCompositeParameters()).getDeviceParameters(), (RspDuoTunerParameters)((RspDuoCompositeParameters)this.getCompositeParameters()).getTunerAParameters(), ((RspDuoCompositeParameters)this.getCompositeParameters()).getControlAParameters()) : new RspDuoTuner2(this, this.getAPI(), (RspDuoDeviceParameters)((RspDuoCompositeParameters)this.getCompositeParameters()).getDeviceParameters(), ((RspDuoCompositeParameters)this.getCompositeParameters()).getTunerBParameters(), ((RspDuoCompositeParameters)this.getCompositeParameters()).getControlBParameters());
        }
        return this.mTuner;
    }

    @Override
    public TunerSelect getTunerSelect() {
        return TunerSelect.fromValue(sdrplay_api_DeviceT.tuner$get(this.getDeviceMemorySegment()));
    }

    public void setTunerSelect(TunerSelect tunerSelect) {
        sdrplay_api_DeviceT.tuner$set(this.getDeviceMemorySegment(), tunerSelect.getValue());
    }

    public RspDuoMode getRspDuoMode() {
        return this.getDeviceStruct().getRspDuoMode();
    }

    public void setRspDuoMode(RspDuoMode mode) throws SDRPlayException {
        if (this.isSelected()) {
            throw new SDRPlayException("RSPduo device is already selected.  Mode can only be set/changed before the device is selected for use.");
        }
        this.getDeviceStruct().setRspDuoMode(mode);
    }

    public double getRspDuoSampleFrequency() {
        return this.getDeviceStruct().getRspDuoSampleFrequency();
    }

    public void setRspDuoSampleFrequency(double frequency) throws SDRPlayException {
        if (!this.getRspDuoMode().equals((Object)RspDuoMode.MASTER)) {
            throw new SDRPlayException("This method can only be used to set the overall sample rate when the RSPduo device is configured for master mode.");
        }
        this.getDeviceStruct().setRspDuoSampleFrequency(frequency);
    }

    @Override
    public void setDecimation(Decimate decimation) throws SDRPlayException {
        if (this.getTunerSelect() == TunerSelect.TUNER_1) {
            ((RspDuoCompositeParameters)this.getCompositeParameters()).getControlAParameters().getDecimation().setDecimationFactor(decimation.getValue());
            ((RspDuoCompositeParameters)this.getCompositeParameters()).getControlAParameters().getDecimation().setEnabled(decimation.isEnabled());
            this.update(this.getTunerSelect(), UpdateReason.CONTROL_DECIMATION);
        } else if (this.getTunerSelect() == TunerSelect.TUNER_2) {
            ((RspDuoCompositeParameters)this.getCompositeParameters()).getControlBParameters().getDecimation().setDecimationFactor(decimation.getValue());
            ((RspDuoCompositeParameters)this.getCompositeParameters()).getControlBParameters().getDecimation().setEnabled(decimation.isEnabled());
            this.update(this.getTunerSelect(), UpdateReason.CONTROL_DECIMATION);
        } else if (this.getTunerSelect() == TunerSelect.TUNER_BOTH) {
            super.setDecimation(decimation);
        }
    }

    public void setIfModeTuner2(IfMode ifMode) {
        ((RspDuoCompositeParameters)this.getCompositeParameters()).getTunerBParameters().setIfMode(ifMode);
    }

    public void setLoModeTuner2(LoMode loMode) {
        ((RspDuoCompositeParameters)this.getCompositeParameters()).getTunerBParameters().setLoMode(loMode);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SDRPplay Device").append("\n");
        sb.append("\tType: " + String.valueOf((Object)this.getDeviceType())).append("\n");
        sb.append("\tSerial Number: " + this.getSerialNumber()).append("\n");
        sb.append("\tTuner: " + String.valueOf((Object)this.getTunerSelect())).append("\n");
        sb.append("\tRSP Duo: " + String.valueOf((Object)this.getRspDuoMode())).append("\n");
        sb.append("\tRSP Duo Sample Rate: " + this.getRspDuoSampleFrequency()).append("\n");
        sb.append("\tSelected: " + this.isSelected());
        if (this.hasCompositeParameters()) {
            sb.append("\t").append(this.getCompositeParameters());
        }
        return sb.toString();
    }
}

