/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum Version {
    UNKNOWN(0.0f, false),
    V3_07(3.07f, true),
    V3_08(3.08f, true),
    V3_09(3.09f, true),
    V3_10(3.1f, true),
    V3_11(3.11f, true),
    V3_12(3.12f, true);

    private float mValue;
    private boolean mSupported;
    private static final Logger mLog;

    private Version(float value, boolean supported) {
        this.mValue = value;
        this.mSupported = supported;
    }

    public boolean isSupported() {
        return this.mSupported;
    }

    public boolean gte(Version version) {
        return this.ordinal() >= version.ordinal();
    }

    public float getVersion() {
        return this.mValue;
    }

    public static Version fromValue(float value) {
        for (Version version : Version.values()) {
            if (version.mValue != value) continue;
            return version;
        }
        mLog.warn("Unrecognized SDRplay API version [" + value + "]");
        return UNKNOWN;
    }

    public String toString() {
        return String.valueOf(this.mValue);
    }

    static {
        mLog = LoggerFactory.getLogger(Version.class);
    }
}

