/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay.api;

import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayUpdateException;
import io.github.dsheirer.source.tuner.sdrplay.api.Status;
import io.github.dsheirer.source.tuner.sdrplay.api.UpdateReason;
import io.github.dsheirer.source.tuner.sdrplay.api.Version;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.CallbackFunctions;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.IDeviceEventListener;
import io.github.dsheirer.source.tuner.sdrplay.api.callback.IStreamListener;
import io.github.dsheirer.source.tuner.sdrplay.api.device.Device;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceFactory;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceInfo;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceType;
import io.github.dsheirer.source.tuner.sdrplay.api.device.IDeviceStruct;
import io.github.dsheirer.source.tuner.sdrplay.api.device.TunerSelect;
import io.github.dsheirer.source.tuner.sdrplay.api.error.DebugLevel;
import io.github.dsheirer.source.tuner.sdrplay.api.error.ErrorInformation;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.CompositeParameters;
import io.github.dsheirer.source.tuner.sdrplay.api.parameter.composite.CompositeParametersFactory;
import io.github.dsheirer.source.tuner.sdrplay.api.util.Flag;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_DeviceT;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_ErrorInfoT;
import io.github.dsheirer.source.tuner.sdrplay.api.v3_07.sdrplay_api_h;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SDRplay {
    public static final String SDRPLAY_API_LIBRARY_NAME = "sdrplay_api";
    public static final String SDRPLAY_API_PATH_LINUX = "/usr/local/lib/libsdrplay_api.so";
    public static final String SDRPLAY_API_PATH_MAC_OS = "/usr/local/lib/libsdrplay_api.dylib";
    public static final String SDRPLAY_API_PATH_WINDOWS = System.getenv("ProgramFiles") + "\\SDRplay\\API\\" + (System.getProperty("sun.arch.data.model").contentEquals("64") ? "x64" : "x86") + "\\sdrplay_api";
    public static final String JAVA_LIBRARY_PATH_KEY = "java.library.path";
    private static final Logger mLog = LoggerFactory.getLogger(SDRplay.class);
    private final Arena mArena = Arena.openShared();
    private boolean mSdrplayLibraryLoaded;
    private boolean mAvailable;
    private final Map<MemorySegment, CallbackFunctions> mDeviceCallbackFunctionsMap = new HashMap<MemorySegment, CallbackFunctions>();
    private Version mVersion;
    private static boolean sLibraryLoadStatusLogging = true;

    public SDRplay() throws SDRPlayException {
        this.mSdrplayLibraryLoaded = this.loadLibrary();
        if (this.mSdrplayLibraryLoaded) {
            Status openStatus = this.open();
            if (sLibraryLoadStatusLogging) {
                mLog.info("API library - open status: " + String.valueOf((Object)openStatus));
            }
            boolean bl = this.mAvailable = openStatus.success() && this.getVersion().isSupported();
            if (openStatus == Status.FAIL) {
                throw new SDRPlayException("Service not available");
            }
        } else {
            if (sLibraryLoadStatusLogging) {
                mLog.info("API library was not loaded");
            }
            this.mAvailable = false;
        }
        if (this.isAvailable()) {
            if (sLibraryLoadStatusLogging) {
                mLog.info("API library v" + String.valueOf((Object)this.getVersion()) + " - loaded");
            }
        } else if (sLibraryLoadStatusLogging) {
            mLog.info("API library is not available.");
        }
        sLibraryLoadStatusLogging = false;
    }

    private Arena getArena() {
        return this.mArena;
    }

    private boolean loadLibrary() {
        try {
            String libraryPath = SDRplay.getSDRplayLibraryPath();
            if (sLibraryLoadStatusLogging) {
                mLog.info("Loading API Library from default install path: " + libraryPath);
            }
            System.loadLibrary(SDRPLAY_API_LIBRARY_NAME);
            return true;
        }
        catch (Throwable t) {
            mLog.error("Unable to load SDRplay API library from default install path.  Loading from java system library path");
            try {
                System.loadLibrary(SDRPLAY_API_LIBRARY_NAME);
                return true;
            }
            catch (Throwable t2) {
                String name = System.mapLibraryName(SDRPLAY_API_LIBRARY_NAME);
                if (sLibraryLoadStatusLogging) {
                    mLog.warn("SDRPlay API library not found/installed on this system.  Ensure the API is installed either in the default install location or the install location is included in the 'java.library.path' JVM property contains path to the library file [" + name + "].  Current library path property contents: " + System.getProperty(JAVA_LIBRARY_PATH_KEY));
                }
                return false;
            }
        }
    }

    public List<DeviceInfo> getDeviceInfos() throws SDRPlayException {
        return DeviceFactory.parseDeviceInfos(this.getDeviceStructures());
    }

    public List<IDeviceStruct> getDeviceStructures() throws SDRPlayException {
        MemorySegment deviceCount;
        ArrayList<IDeviceStruct> deviceStructs = new ArrayList<IDeviceStruct>();
        MemorySegment devicesArray = DeviceFactory.createDeviceArray(this.getVersion(), this.getArena());
        Status status = Status.fromValue(sdrplay_api_h.sdrplay_api_GetDevices(devicesArray, deviceCount = this.getArena().allocate(ValueLayout.JAVA_INT, 0), sdrplay_api_h.SDRPLAY_MAX_DEVICES()));
        if (status.success()) {
            int count = deviceCount.get(ValueLayout.JAVA_INT, 0L);
            deviceStructs.addAll(DeviceFactory.parseDeviceStructs(this.getVersion(), devicesArray, count));
        } else {
            mLog.error("Couldn't load RSP devices from API.  Status: " + String.valueOf((Object)status));
        }
        return deviceStructs;
    }

    public DeviceInfo getDevice(String serialNumber) throws SDRPlayException {
        for (DeviceInfo deviceInfo : this.getDeviceInfos()) {
            if (!deviceInfo.getSerialNumber().equals(serialNumber)) continue;
            return deviceInfo;
        }
        return null;
    }

    public Device getDevice(DeviceInfo deviceInfo) throws SDRPlayException {
        Device device = null;
        if (this.isAvailable()) {
            List<IDeviceStruct> deviceStructs = this.getDeviceStructures();
            for (IDeviceStruct deviceStruct : deviceStructs) {
                if (!deviceInfo.matches(deviceStruct)) continue;
                device = DeviceFactory.createDevice(this, deviceStruct);
                break;
            }
        }
        if (device == null) {
            throw new SDRPlayException("Unable to find RSP device");
        }
        return device;
    }

    public DeviceInfo getDeviceInfo(DeviceType deviceType) throws SDRPlayException {
        for (DeviceInfo deviceInfo : this.getDeviceInfos()) {
            if (deviceInfo.getDeviceType() != deviceType) continue;
            return deviceInfo;
        }
        return null;
    }

    public void select(MemorySegment memorySegment) throws SDRPlayException {
        this.lockDeviceApi();
        Status selectStatus = Status.fromValue(sdrplay_api_h.sdrplay_api_SelectDevice(memorySegment));
        this.unlockDeviceApi();
        if (selectStatus.fail()) {
            throw new SDRPlayException("Unable to select the device", selectStatus);
        }
    }

    public void release(MemorySegment memorySegment) throws SDRPlayException {
        Status status = Status.fromValue(sdrplay_api_h.sdrplay_api_ReleaseDevice(memorySegment));
        if (status.fail()) {
            mLog.info("API call to release device failed, however device is effectively released now.");
        }
    }

    public CompositeParameters getCompositeParameters(DeviceType deviceType, MemorySegment deviceHandle) throws SDRPlayException {
        MemorySegment pointer = this.getArena().allocate(ValueLayout.ADDRESS);
        Status status = Status.fromValue(sdrplay_api_h.sdrplay_api_GetDeviceParams(deviceHandle, pointer));
        if (status.success()) {
            MemorySegment memoryAddress = pointer.get((ValueLayout.OfAddress)ValueLayout.ADDRESS, 0L);
            MemorySegment memorySegment = sdrplay_api_DeviceT.ofAddress(memoryAddress, this.getArena().scope());
            return CompositeParametersFactory.create(deviceType, memorySegment, this.getArena());
        }
        throw new SDRPlayException("Error retrieving device composite parameters", status);
    }

    private void init(MemorySegment deviceHandle, MemorySegment callbackFunctions) throws SDRPlayException {
        MemorySegment contextPointer = this.getArena().allocate((ValueLayout.OfAddress)ValueLayout.ADDRESS, callbackFunctions);
        Status status = Status.fromValue(sdrplay_api_h.sdrplay_api_Init(deviceHandle, callbackFunctions, contextPointer));
        if (!status.success()) {
            throw new SDRPlayException("Error while initializing device", status);
        }
    }

    public void initA(Device device, MemorySegment deviceHandle, IDeviceEventListener eventListener, IStreamListener streamListener) throws SDRPlayException {
        CallbackFunctions callbackFunctions = this.mDeviceCallbackFunctionsMap.get(deviceHandle);
        if (callbackFunctions == null) {
            callbackFunctions = new CallbackFunctions(this.getArena(), eventListener, streamListener, device.getStreamCallbackListener());
            this.mDeviceCallbackFunctionsMap.put(deviceHandle, callbackFunctions);
        } else {
            callbackFunctions.setDeviceEventListener(eventListener);
            callbackFunctions.setStreamAListener(streamListener);
        }
        this.init(deviceHandle, callbackFunctions.getCallbackFunctionsMemorySegment());
    }

    public void initB(Device device, MemorySegment deviceHandle, IDeviceEventListener eventListener, IStreamListener streamListener) throws SDRPlayException {
        CallbackFunctions callbackFunctions = this.mDeviceCallbackFunctionsMap.get(deviceHandle);
        if (callbackFunctions == null) {
            callbackFunctions = new CallbackFunctions(this.getArena(), eventListener, streamListener, streamListener, device.getStreamCallbackListener());
            this.mDeviceCallbackFunctionsMap.put(deviceHandle, callbackFunctions);
        } else {
            callbackFunctions.setDeviceEventListener(eventListener);
            callbackFunctions.setStreamAListener(streamListener);
        }
        this.init(deviceHandle, callbackFunctions.getCallbackFunctionsMemorySegment());
    }

    public void uninit(MemorySegment deviceHandle) throws SDRPlayException {
        Status status = Status.fromValue(sdrplay_api_h.sdrplay_api_Uninit(deviceHandle));
        if (status.fail() && status != Status.NOT_INITIALIZED) {
            throw new SDRPlayException("Error while un-initializing device", status);
        }
    }

    public synchronized void update(Device device, MemorySegment deviceHandle, TunerSelect tunerSelect, UpdateReason ... updateReasons) throws SDRPlayException {
        int reasons = UpdateReason.getReasons(updateReasons);
        int extendedReasons = UpdateReason.getExtendedReasons(updateReasons);
        Status status = Status.fromValue(sdrplay_api_h.sdrplay_api_Update(deviceHandle, tunerSelect.getValue(), reasons, extendedReasons));
        if (status.fail()) {
            throw new SDRPlayUpdateException(status, Arrays.stream(updateReasons).toList());
        }
    }

    private ErrorInformation getLastError(MemorySegment deviceSegment) {
        MemorySegment errorAddress = sdrplay_api_h.sdrplay_api_GetLastError(deviceSegment);
        MemorySegment errorSegment = sdrplay_api_ErrorInfoT.ofAddress(errorAddress, this.getArena().scope());
        return new ErrorInformation(errorSegment);
    }

    public void setDebugLevel(MemorySegment deviceHandle, DebugLevel debugLevel) throws SDRPlayException {
        Status status = Status.UNKNOWN;
        if (this.getVersion() == Version.V3_07) {
            status = Status.fromValue(sdrplay_api_h.sdrplay_api_DebugEnable(deviceHandle, debugLevel.getValue()));
        } else if (this.getVersion().gte(Version.V3_08)) {
            boolean enable = debugLevel != DebugLevel.DISABLE;
            status = Status.fromValue(sdrplay_api_h.sdrplay_api_DebugEnable(deviceHandle, Flag.of(enable)));
        }
        if (status.fail()) {
            throw new SDRPlayException("Unable to set debug level", status);
        }
    }

    public boolean isAvailable() {
        return this.mAvailable;
    }

    private Status open() {
        return Status.fromValue(sdrplay_api_h.sdrplay_api_Open());
    }

    public Status close() {
        if (this.mSdrplayLibraryLoaded) {
            Status closeStatus;
            try {
                closeStatus = Status.fromValue(sdrplay_api_h.sdrplay_api_Close());
            }
            catch (Exception e) {
                closeStatus = Status.FAIL;
                mLog.error("Error closing SDRPlay API");
            }
            this.mSdrplayLibraryLoaded = false;
            this.mAvailable = false;
            return closeStatus;
        }
        return Status.API_UNAVAILABLE;
    }

    public Version getVersion() {
        if (this.mVersion == null) {
            MemorySegment apiVersion;
            Status status;
            if (this.mSdrplayLibraryLoaded && (status = Status.fromValue(sdrplay_api_h.sdrplay_api_ApiVersion(apiVersion = this.getArena().allocate(ValueLayout.JAVA_FLOAT, 0.0f)))).success()) {
                float version = apiVersion.get(ValueLayout.JAVA_FLOAT, 0L);
                this.mVersion = Version.fromValue(version);
            }
            if (this.mVersion == null) {
                this.mVersion = Version.UNKNOWN;
            }
        }
        return this.mVersion;
    }

    private void lockDeviceApi() throws SDRPlayException {
        if (this.isAvailable()) {
            Status status = Status.fromValue(sdrplay_api_h.sdrplay_api_LockDeviceApi());
            if (status.fail()) {
                throw new SDRPlayException("Unable to lock Device API for exclusive use", status);
            }
        } else {
            throw new SDRPlayException("API is unavailable", Status.API_UNAVAILABLE);
        }
    }

    private void unlockDeviceApi() throws SDRPlayException {
        if (this.isAvailable()) {
            Status status = Status.fromValue(sdrplay_api_h.sdrplay_api_UnlockDeviceApi());
            if (status.fail()) {
                throw new SDRPlayException("Unable to unlock Device API", status);
            }
        } else {
            throw new SDRPlayException("API is unavailable", Status.API_UNAVAILABLE);
        }
    }

    public static String getSDRplayLibraryPath() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return SDRPLAY_API_PATH_WINDOWS;
        }
        if (SystemUtils.IS_OS_LINUX) {
            return SDRPLAY_API_PATH_LINUX;
        }
        if (SystemUtils.IS_OS_MAC_OSX) {
            return SDRPLAY_API_PATH_MAC_OS;
        }
        mLog.error("Unrecognized operating system.  Cannot identify sdrplay api library path");
        return "";
    }

    public static void main(String[] args) {
        try {
            SDRplay sdrplay = new SDRplay();
            Status status = sdrplay.open();
            mLog.info("Open Status: " + String.valueOf((Object)status));
            for (DeviceInfo deviceInfo : sdrplay.getDeviceInfos()) {
                mLog.info("Found: " + String.valueOf(deviceInfo));
            }
            Status closeStatus = sdrplay.close();
            mLog.info("Close Status: " + String.valueOf((Object)closeStatus));
        }
        catch (SDRPlayException se) {
            mLog.info("Error", (Throwable)se);
        }
    }
}

