/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.sdrplay;

import io.github.dsheirer.buffer.AbstractNativeBuffer;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.InterleavedComplexSamples;
import java.util.Iterator;

public class RspNativeBuffer
extends AbstractNativeBuffer {
    private static final float SAMPLE_TO_FLOAT = 3.0517578E-5f;
    private short[] mISamples;
    private short[] mQSamples;

    public RspNativeBuffer(short[] i, short[] q, long timestamp, float samplesPerMillisecond) {
        super(timestamp, samplesPerMillisecond);
        this.mISamples = i;
        this.mQSamples = q;
    }

    @Override
    public Iterator<ComplexSamples> iterator() {
        return new SampleIterator();
    }

    @Override
    public Iterator<InterleavedComplexSamples> iteratorInterleaved() {
        return new InterleavedSampleIterator();
    }

    @Override
    public int sampleCount() {
        return this.mISamples.length * 2;
    }

    private class SampleIterator
    implements Iterator<ComplexSamples> {
        private int mSamplePointer;

        private SampleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mSamplePointer < RspNativeBuffer.this.mISamples.length;
        }

        @Override
        public ComplexSamples next() {
            float[] i = new float[RspNativeBuffer.this.mISamples.length];
            float[] q = new float[RspNativeBuffer.this.mISamples.length];
            for (int x = 0; x < RspNativeBuffer.this.mISamples.length; ++x) {
                i[x] = (float)RspNativeBuffer.this.mISamples[x] * 3.0517578E-5f;
                q[x] = (float)RspNativeBuffer.this.mQSamples[x] * 3.0517578E-5f;
            }
            this.mSamplePointer += RspNativeBuffer.this.mISamples.length;
            return new ComplexSamples(i, q, RspNativeBuffer.this.getTimestamp());
        }
    }

    private class InterleavedSampleIterator
    implements Iterator<InterleavedComplexSamples> {
        private int mSamplePointer;

        private InterleavedSampleIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.mSamplePointer < RspNativeBuffer.this.mISamples.length;
        }

        @Override
        public InterleavedComplexSamples next() {
            float[] samples = new float[RspNativeBuffer.this.mISamples.length * 2];
            int index = 0;
            for (int x = 0; x < RspNativeBuffer.this.mISamples.length; ++x) {
                samples[index++] = (float)RspNativeBuffer.this.mISamples[x] * 3.0517578E-5f;
                samples[index++] = (float)RspNativeBuffer.this.mQSamples[x] * 3.0517578E-5f;
            }
            this.mSamplePointer += RspNativeBuffer.this.mISamples.length;
            return new InterleavedComplexSamples(samples, RspNativeBuffer.this.getTimestamp());
        }
    }
}

