/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.rtl;

import io.github.dsheirer.buffer.ByteNativeBufferFactory;
import io.github.dsheirer.buffer.INativeBufferFactory;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.TunerFactory;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.rtl.EmbeddedTuner;
import io.github.dsheirer.source.tuner.rtl.RTL2832TunerConfiguration;
import io.github.dsheirer.source.tuner.usb.USBTunerController;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usb4java.DeviceHandle;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;

public class RTL2832TunerController
extends USBTunerController {
    private static final Logger mLog = LoggerFactory.getLogger(RTL2832TunerController.class);
    public static final int TWO_TO_22_POWER = 0x400000;
    public static final int USB_TRANSFER_BUFFER_SIZE = 65536;
    public static final byte CONTROL_ENDPOINT_IN = -64;
    public static final byte CONTROL_ENDPOINT_OUT = 64;
    public static final long TIMEOUT_US = 1000000L;
    public static final byte REQUEST_ZERO = 0;
    public static final byte EEPROM_ADDRESS = -96;
    public static final byte[] FIR_FILTER_COEFFICIENTS = new byte[]{-54, -36, -41, -40, -32, -14, 14, 53, 6, 80, -100, 13, 113, 17, 20, 113, 116, 25, 65, -91};
    public static final SampleRate DEFAULT_SAMPLE_RATE = SampleRate.RATE_2_400MHZ;
    private SampleRate mSampleRate = DEFAULT_SAMPLE_RATE;
    private INativeBufferFactory mNativeBufferFactory = new ByteNativeBufferFactory();
    private int mOscillatorFrequency = 28800000;
    private Descriptor mDescriptor;
    private EmbeddedTuner mEmbeddedTuner;
    private long mTunedFrequency = 0L;
    private boolean mBiasTEnabled = false;
    private ReentrantLock mLock = new ReentrantLock();

    public RTL2832TunerController(int bus, String portAddress, ITunerErrorListener tunerErrorListener) {
        super(bus, portAddress, tunerErrorListener);
    }

    private ReentrantLock getLock() {
        return this.mLock;
    }

    @Override
    protected INativeBufferFactory getNativeBufferFactory() {
        return this.mNativeBufferFactory;
    }

    @Override
    protected int getTransferBufferSize() {
        return 65536;
    }

    @Override
    public int getBufferSampleCount() {
        return this.getTransferBufferSize() / 2;
    }

    public EmbeddedTuner getEmbeddedTuner() {
        return this.mEmbeddedTuner;
    }

    public boolean hasEmbeddedTuner() {
        return this.mEmbeddedTuner != null;
    }

    @Override
    public void setTunedFrequency(long frequency) throws SourceException {
        this.getEmbeddedTuner().setTunedFrequency(frequency);
        this.mTunedFrequency = frequency;
    }

    @Override
    public long getTunedFrequency() throws SourceException {
        return this.mTunedFrequency;
    }

    @Override
    public void apply(TunerConfiguration tunerConfig) throws SourceException {
        super.apply(tunerConfig);
        if (tunerConfig instanceof RTL2832TunerConfiguration) {
            RTL2832TunerConfiguration rtl = (RTL2832TunerConfiguration)tunerConfig;
            this.setSampleRate(rtl.getSampleRate());
            this.getEmbeddedTuner().apply(rtl);
        }
    }

    @Override
    protected void deviceStart() throws SourceException {
        boolean resetRequired = false;
        try {
            this.writeRegister(Block.USB, Address.USB_SYSCTL, 9, 1);
        }
        catch (LibUsbException lue) {
            if (lue.getErrorCode() < 0) {
                resetRequired = true;
            }
            mLog.error("Error performing test write to RTL2832 device - " + LibUsb.errorName((int)lue.getErrorCode()));
        }
        if (resetRequired) {
            int status = LibUsb.resetDevice((DeviceHandle)this.getDeviceHandle());
            mLog.info("Resetting device - status: " + LibUsb.errorName((int)status));
            try {
                this.writeRegister(Block.USB, Address.USB_SYSCTL, 9, 1);
            }
            catch (LibUsbException lue) {
                mLog.error("Couldnt' reset RTL2832 device - setting error");
                throw new SourceException("unable to reset USB device - " + LibUsb.errorName((int)status));
            }
        }
        byte[] eeprom = null;
        try {
            eeprom = this.readEEPROM((short)0, 256);
        }
        catch (Exception e) {
            mLog.error("error while reading the EEPROM device descriptor", (Throwable)e);
        }
        try {
            this.mDescriptor = new Descriptor(this, eeprom);
            if (eeprom == null) {
                mLog.error("eeprom byte array was null - constructed empty descriptor object");
            }
        }
        catch (Exception e) {
            mLog.error("error while constructing device descriptor using descriptor byte array " + (eeprom == null ? "[null]" : Arrays.toString(eeprom)), (Throwable)e);
        }
        this.initBaseband();
        TunerType tunerType = this.identifyTunerType();
        if (tunerType == TunerType.UNKNOWN) {
            throw new SourceException("Unrecognized RTL-2832 embedded tuner type: " + String.valueOf((Object)tunerType));
        }
        this.mEmbeddedTuner = TunerFactory.getRtlEmbeddedTuner(tunerType, new ControllerAdapter(this, this));
        try {
            this.enableI2CRepeater(true);
            this.getEmbeddedTuner().initTuner();
            this.enableI2CRepeater(false);
        }
        catch (UsbException ue) {
            throw new SourceException("Unable to initialize " + String.valueOf((Object)tunerType), ue);
        }
        this.setMinimumFrequency(this.mEmbeddedTuner.getMinimumFrequencySupported());
        this.setMaximumFrequency(this.mEmbeddedTuner.getMaximumFrequencySupported());
        this.setMiddleUnusableHalfBandwidth(this.mEmbeddedTuner.getDcSpikeHalfBandwidth());
        this.setUsableBandwidthPercentage(this.mEmbeddedTuner.getUsableBandwidthPercent());
        try {
            this.setSampleRate(DEFAULT_SAMPLE_RATE);
        }
        catch (Exception e) {
            throw new SourceException("RTL2832 Tuner Controller - couldn't set default sample rate", e);
        }
    }

    @Override
    protected void deviceStop() {
        try {
            this.deinitBaseband();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Descriptor getDescriptor() {
        if (this.mDescriptor != null && this.mDescriptor.isValid()) {
            return this.mDescriptor;
        }
        return null;
    }

    public void setBiasT(boolean enabled) {
        this.setGPIOOutput((byte)1);
        this.setGPIOBit((byte)1, enabled);
        this.mBiasTEnabled = enabled;
    }

    public boolean isBiasT() {
        return this.mBiasTEnabled;
    }

    @Override
    public void setMeasuredFrequencyError(int measuredFrequencyError) {
        super.setMeasuredFrequencyError(measuredFrequencyError);
        this.getFrequencyErrorCorrectionManager().updatePPM(this.getPPMFrequencyError());
    }

    private void setIFFrequency(int frequency) throws LibUsbException {
        long ifFrequency = 0x400000L * (long)frequency / (long)this.mOscillatorFrequency * -1L;
        this.writeDemodRegister(Page.ONE, (short)25, (short)(Long.rotateRight(ifFrequency, 16) & 0x3FL), 1);
        this.writeDemodRegister(Page.ONE, (short)26, (short)(Long.rotateRight(ifFrequency, 8) & 0xFFL), 1);
        this.writeDemodRegister(Page.ONE, (short)27, (short)(ifFrequency & 0xFFL), 1);
    }

    public String getUniqueID() {
        if (this.mDescriptor != null) {
            if (this.mDescriptor.hasSerial()) {
                if (this.hasEmbeddedTuner()) {
                    return String.valueOf((Object)TunerClass.RTL2832) + "/" + this.getTunerType().getLabel() + " " + this.mDescriptor.getSerial();
                }
                return String.valueOf((Object)TunerClass.RTL2832) + " " + this.mDescriptor.getSerial();
            }
            return "RTL-2832 USB Bus:" + this.mBus + " Port:" + this.mPortAddress;
        }
        int serial = 0xFF & this.getDeviceDescriptor().iSerialNumber();
        return String.valueOf((Object)TunerClass.RTL2832) + " " + serial;
    }

    public void setSampleRateFilters(int sampleRate) throws SourceException {
        this.getEmbeddedTuner().setSampleRateFilters(sampleRate);
    }

    @Override
    public TunerType getTunerType() {
        if (this.getEmbeddedTuner() != null) {
            return this.getEmbeddedTuner().getTunerType();
        }
        return TunerType.UNKNOWN;
    }

    private TunerType identifyTunerType() throws SourceException {
        TunerType tunerClass = TunerType.UNKNOWN;
        try {
            this.enableI2CRepeater(true);
            boolean controlI2CRepeater = false;
            if (this.isTuner(TunerTypeCheck.E4K, controlI2CRepeater)) {
                tunerClass = TunerType.ELONICS_E4000;
            } else if (this.isTuner(TunerTypeCheck.R820T, controlI2CRepeater)) {
                tunerClass = TunerType.RAFAELMICRO_R820T;
            } else if (this.isTuner(TunerTypeCheck.FC0013, controlI2CRepeater)) {
                tunerClass = TunerType.FITIPOWER_FC0013;
            } else if (this.isTuner(TunerTypeCheck.R828D, controlI2CRepeater)) {
                tunerClass = TunerType.RAFAELMICRO_R828D;
            } else if (this.isTuner(TunerTypeCheck.FC2580, controlI2CRepeater)) {
                tunerClass = TunerType.FCI_FC2580;
            } else if (this.isTuner(TunerTypeCheck.FC0012, controlI2CRepeater)) {
                tunerClass = TunerType.FITIPOWER_FC0012;
            }
            this.enableI2CRepeater(false);
        }
        catch (Exception e) {
            mLog.error("error while determining tuner type", (Throwable)e);
        }
        return tunerClass;
    }

    @Override
    protected void prepareStreaming() {
        this.resetUSBBuffer();
    }

    public void resetUSBBuffer() throws LibUsbException {
        this.writeRegister(Block.USB, Address.USB_EPA_CTL, 4098, 2);
        this.writeRegister(Block.USB, Address.USB_EPA_CTL, 0, 2);
    }

    public void initBaseband() throws LibUsbException {
        this.writeRegister(Block.USB, Address.USB_SYSCTL, 9, 1);
        this.writeRegister(Block.USB, Address.USB_EPA_MAXPKT, 2, 2);
        this.writeRegister(Block.USB, Address.USB_EPA_CTL, 4098, 2);
        this.writeRegister(Block.SYS, Address.DEMOD_CTL_1, 34, 1);
        this.writeRegister(Block.SYS, Address.DEMOD_CTL, 232, 1);
        this.writeDemodRegister(Page.ONE, (short)1, 20, 1);
        this.writeDemodRegister(Page.ONE, (short)1, 16, 1);
        this.writeDemodRegister(Page.ONE, (short)21, 0, 1);
        this.writeDemodRegister(Page.ONE, (short)22, 0, 2);
        this.writeDemodRegister(Page.ONE, (short)22, 0, 1);
        this.writeDemodRegister(Page.ONE, (short)23, 0, 1);
        this.writeDemodRegister(Page.ONE, (short)24, 0, 1);
        this.writeDemodRegister(Page.ONE, (short)25, 0, 1);
        this.writeDemodRegister(Page.ONE, (short)26, 0, 1);
        this.writeDemodRegister(Page.ONE, (short)27, 0, 1);
        for (int x = 0; x < FIR_FILTER_COEFFICIENTS.length; ++x) {
            this.writeDemodRegister(Page.ONE, (short)(28 + x), FIR_FILTER_COEFFICIENTS[x], 1);
        }
        this.writeDemodRegister(Page.ZERO, (short)25, 5, 1);
        this.writeDemodRegister(Page.ONE, (short)147, 240, 1);
        this.writeDemodRegister(Page.ONE, (short)148, 15, 1);
        this.writeDemodRegister(Page.ONE, (short)17, 0, 1);
        this.writeDemodRegister(Page.ONE, (short)4, 0, 1);
        this.writeDemodRegister(Page.ZERO, (short)97, 96, 1);
        this.writeDemodRegister(Page.ZERO, (short)6, 128, 1);
        this.writeDemodRegister(Page.ONE, (short)177, 27, 1);
        this.writeDemodRegister(Page.ZERO, (short)13, 131, 1);
    }

    private void deinitBaseband() throws IllegalArgumentException, UsbDisconnectedException {
        this.writeRegister(Block.SYS, Address.DEMOD_CTL, 32, 1);
    }

    private void setGPIOBit(byte bitMask, boolean enabled) throws LibUsbException {
        int value = this.readRegister(Block.SYS, Address.GPO, 1);
        value = enabled ? (value |= bitMask) : (value &= ~bitMask);
        this.writeRegister(Block.SYS, Address.GPO, value, 1);
    }

    private void setGPIOOutput(byte bitMask) throws LibUsbException {
        int value = this.readRegister(Block.SYS, Address.GPD, 1);
        this.writeRegister(Block.SYS, Address.GPO, value & ~bitMask, 1);
        value = this.readRegister(Block.SYS, Address.GPOE, 1);
        this.writeRegister(Block.SYS, Address.GPOE, value | bitMask, 1);
    }

    private void enableI2CRepeater(boolean enabled) throws LibUsbException {
        short address = 1;
        int value = enabled ? 24 : 16;
        this.writeDemodRegister(Page.ONE, address, value, 1);
    }

    private boolean isI2CRepeaterEnabled() {
        return this.readDemodRegister(Page.ONE, (short)1, 1) == 24;
    }

    private int readI2CRegister(byte i2CAddress, byte i2CRegister, boolean controlI2CRepeater) throws LibUsbException {
        short address = (short)(i2CAddress & 0xFF);
        ByteBuffer buffer = ByteBuffer.allocateDirect(1);
        buffer.put(i2CRegister);
        buffer.rewind();
        ByteBuffer data = ByteBuffer.allocateDirect(1);
        if (controlI2CRepeater) {
            this.enableI2CRepeater(true);
            this.write(address, Block.I2C, buffer);
            this.read(address, Block.I2C, data);
            this.enableI2CRepeater(false);
        } else {
            this.write(address, Block.I2C, buffer);
            this.read(address, Block.I2C, data);
        }
        return data.get() & 0xFF;
    }

    private void writeI2CRegister(byte i2CAddress, byte i2CRegister, byte value, boolean controlI2CRepeater) throws LibUsbException {
        short address = (short)(i2CAddress & 0xFF);
        ByteBuffer buffer = ByteBuffer.allocateDirect(2);
        buffer.put(i2CRegister);
        buffer.put(value);
        buffer.rewind();
        if (controlI2CRepeater) {
            this.enableI2CRepeater(true);
            this.write(address, Block.I2C, buffer);
            this.enableI2CRepeater(false);
        } else {
            this.write(address, Block.I2C, buffer);
        }
    }

    private void writeDemodRegister(Page page, short address, int value, int length) throws LibUsbException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(length);
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (length == 1) {
            buffer.put((byte)(value & 0xFF));
        } else if (length == 2) {
            buffer.putShort((short)(value & 0xFFFF));
        } else {
            throw new IllegalArgumentException("Cannot write value greater than 16 bits to the register - length [" + length + "]");
        }
        short index = (short)(0x10 | page.getPage());
        short newAddress = (short)(address << 8 | 0x20);
        this.write(newAddress, index, buffer);
        this.readDemodRegister(Page.TEN, (short)1, length);
    }

    private int readDemodRegister(Page page, short address, int length) throws LibUsbException {
        short index = page.getPage();
        short newAddress = (short)(address << 8 | 0x20);
        ByteBuffer buffer = ByteBuffer.allocateDirect(length);
        this.read(newAddress, index, buffer);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (length == 2) {
            return buffer.getShort() & 0xFFFF;
        }
        return buffer.get() & 0xFF;
    }

    private void writeRegister(Block block, Address address, int value, int length) throws LibUsbException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(length);
        buffer.order(ByteOrder.BIG_ENDIAN);
        if (length == 1) {
            buffer.put((byte)(value & 0xFF));
        } else if (length == 2) {
            buffer.putShort((short)value);
        } else {
            throw new IllegalArgumentException("Cannot write value greater than 16 bits to the register - length [" + length + "]");
        }
        buffer.rewind();
        this.write(address.getAddress(), block, buffer);
    }

    private int readRegister(Block block, Address address, int length) throws LibUsbException {
        ByteBuffer buffer = ByteBuffer.allocateDirect(2);
        this.read(address.getAddress(), block, buffer);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        if (length == 2) {
            return buffer.getShort() & 0xFFFF;
        }
        return buffer.get() & 0xFF;
    }

    private void write(short address, Block block, ByteBuffer buffer) throws LibUsbException {
        this.write(address, block.getWriteIndex(), buffer);
    }

    private void write(short value, short index, ByteBuffer buffer) throws LibUsbException {
        if (this.hasDeviceHandle()) {
            int transferred = LibUsb.controlTransfer((DeviceHandle)this.getDeviceHandle(), (byte)64, (byte)0, (short)value, (short)index, (ByteBuffer)buffer, (long)1000000L);
            if (transferred < 0) {
                throw new LibUsbException("error writing byte buffer", transferred);
            }
            if (transferred != buffer.capacity()) {
                throw new LibUsbException("transferred bytes [" + transferred + "] is not what was expected [" + buffer.capacity() + "]", transferred);
            }
        } else {
            throw new LibUsbException("device handle is null", -4);
        }
    }

    private void read(short address, short index, ByteBuffer buffer) throws LibUsbException {
        if (this.isRunning()) {
            int transferred = LibUsb.controlTransfer((DeviceHandle)this.getDeviceHandle(), (byte)-64, (byte)0, (short)address, (short)index, (ByteBuffer)buffer, (long)1000000L);
            if (transferred < 0) {
                throw new LibUsbException("read error", transferred);
            }
            if (transferred != buffer.capacity()) {
                throw new LibUsbException("transferred bytes [" + transferred + "] is not what was expected [" + buffer.capacity() + "]", transferred);
            }
        }
    }

    private void read(short address, Block block, ByteBuffer buffer) throws LibUsbException {
        this.read(address, block.getReadIndex(), buffer);
    }

    private boolean isTuner(TunerTypeCheck type, boolean controlI2CRepeater) {
        try {
            if (type == TunerTypeCheck.FC0012 || type == TunerTypeCheck.FC2580) {
                this.setGPIOOutput((byte)32);
                this.setGPIOBit((byte)32, true);
                this.setGPIOBit((byte)32, false);
            }
            int value = this.readI2CRegister(type.getI2CAddress(), type.getCheckAddress(), controlI2CRepeater);
            if (type == TunerTypeCheck.FC2580) {
                return (value & 0x7F) == (type.getCheckValue() & 0xFF);
            }
            return value == (type.getCheckValue() & 0xFF);
        }
        catch (LibUsbException libUsbException) {
            return false;
        }
    }

    @Override
    public double getCurrentSampleRate() {
        return this.mSampleRate.getRate();
    }

    public int getSampleRateFromTuner() throws SourceException {
        int returnRate = DEFAULT_SAMPLE_RATE.getRate();
        this.getLock().lock();
        try {
            int high = this.readDemodRegister(Page.ONE, (short)159, 2);
            int low = this.readDemodRegister(Page.ONE, (short)161, 2);
            int ratio = Integer.rotateLeft(high, 16) | low;
            int rate = this.mOscillatorFrequency * 0x400000 / ratio;
            SampleRate sampleRate = SampleRate.getClosest(rate);
            if (sampleRate.getRate() != rate) {
                this.setSampleRate(sampleRate);
                returnRate = sampleRate.getRate();
            }
        }
        catch (Exception e) {
            throw new SourceException("RTL2832 Tuner Controller - cannot get current sample rate", e);
        }
        finally {
            this.getLock().unlock();
        }
        return returnRate;
    }

    public void setSampleRate(SampleRate sampleRate) throws SourceException {
        this.getLock().lock();
        try {
            this.writeDemodRegister(Page.ONE, (short)159, sampleRate.getRatioHighBits(), 2);
            this.writeDemodRegister(Page.ONE, (short)161, 0, 2);
            this.setSampleRateFrequencyCorrection(0);
            this.writeDemodRegister(Page.ONE, (short)1, 20, 1);
            this.writeDemodRegister(Page.ONE, (short)1, 16, 1);
            this.setSampleRateFilters(sampleRate.getRate());
            this.mSampleRate = sampleRate;
            this.mFrequencyController.setSampleRate(sampleRate.getRate());
            this.getNativeBufferFactory().setSamplesPerMillisecond((float)sampleRate.getRate() / 1000.0f);
        }
        finally {
            this.getLock().unlock();
        }
    }

    private int getUSBTransferBufferSize(double sampleRate) {
        return 65536;
    }

    public void setSampleRateFrequencyCorrection(int ppm) throws SourceException {
        int offset = -ppm * 0x400000 / 1000000;
        this.writeDemodRegister(Page.ONE, (short)63, offset & 0xFF, 1);
        this.writeDemodRegister(Page.ONE, (short)62, Integer.rotateRight(offset, 8) & 0xFF, 1);
        try {
            this.mFrequencyController.setFrequency(this.mFrequencyController.getFrequency());
        }
        catch (Exception e) {
            throw new SourceException("Couldn't set sample rate frequency correction", e);
        }
    }

    public int getSampleRateFrequencyCorrection() throws UsbException {
        int high = this.readDemodRegister(Page.ONE, (short)62, 1);
        int low = this.readDemodRegister(Page.ONE, (short)63, 1);
        return Integer.rotateLeft(high, 8) | low;
    }

    public byte[] readEEPROM(short offset, int length) throws IllegalArgumentException {
        if (offset + length > 256) {
            throw new IllegalArgumentException("cannot read more than 256 bytes from EEPROM - requested read to byte [" + (offset + length) + "]");
        }
        byte[] data = new byte[length];
        ByteBuffer buffer = ByteBuffer.allocateDirect(1);
        try {
            this.writeRegister(Block.I2C, Address.EEPROM, (byte)offset, 1);
        }
        catch (LibUsbException e) {
            mLog.error("usb error while attempting to set read address to EEPROM register, prior to reading the EEPROM device descriptor", (Throwable)e);
        }
        for (int x = 0; x < length; ++x) {
            try {
                this.read((short)-96, Block.I2C, buffer);
                data[x] = buffer.get();
                buffer.rewind();
                continue;
            }
            catch (Exception e) {
                mLog.error("error while reading eeprom byte [" + x + "/" + length + "] aborting eeprom read and returning partially filled descriptor byte array", (Throwable)e);
                x = length;
            }
        }
        return data;
    }

    public void writeEEPROMByte(byte offset, byte value) throws IllegalArgumentException, UsbDisconnectedException {
        if (offset < 0 || offset > 255) {
            throw new IllegalArgumentException("RTL2832 Tuner Controller - EEPROM offset must be within range of 0 - 255");
        }
        int offsetAndValue = Integer.rotateLeft(0xFF & offset, 8) | 0xFF & value;
        this.writeRegister(Block.I2C, Address.EEPROM, offsetAndValue, 2);
    }

    public static enum SampleRate {
        RATE_0_230MHZ(8000, 230400, "0.230 MHz"),
        RATE_0_240MHZ(7680, 240000, "0.240 MHz"),
        RATE_0_256MHZ(7200, 256000, "0.256 MHz"),
        RATE_0_288MHZ(6400, 288000, "0.288 MHz"),
        RATE_0_300MHZ(6144, 300000, "0.300 MHz"),
        RATE_0_960MHZ(1920, 960000, "0.960 MHz"),
        RATE_1_024MHZ(1800, 1024000, "1.024 MHz"),
        RATE_1_200MHZ(1536, 1200000, "1.200 MHz"),
        RATE_1_440MHZ(1280, 1440000, "1.440 MHz"),
        RATE_1_600MHZ(1152, 1600000, "1.600 MHz"),
        RATE_1_800MHZ(1024, 1800000, "1.800 MHz"),
        RATE_1_920MHZ(960, 1920000, "1.920 MHz"),
        RATE_2_048MHZ(900, 2048000, "2.048 MHz"),
        RATE_2_304MHZ(800, 2304000, "2.304 MHz"),
        RATE_2_400MHZ(768, 2400000, "2.400 MHz"),
        RATE_2_560MHZ(720, 2560000, "2.560 MHz"),
        RATE_2_880MHZ(640, 2880000, "2.880 MHz");

        private int mRatioHigh;
        private int mRate;
        private String mLabel;

        private SampleRate(int ratioHigh, int rate, String label) {
            this.mRatioHigh = ratioHigh;
            this.mRate = rate;
            this.mLabel = label;
        }

        public int getRatioHighBits() {
            return this.mRatioHigh;
        }

        public int getRate() {
            return this.mRate;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.mLabel;
        }

        public static SampleRate getClosest(int sampleRate) {
            for (SampleRate rate : SampleRate.values()) {
                if (rate.getRate() < sampleRate) continue;
                return rate;
            }
            return DEFAULT_SAMPLE_RATE;
        }
    }

    public static enum Block {
        DEMOD(0),
        USB(1),
        SYS(2),
        TUN(3),
        ROM(4),
        IR(5),
        I2C(6);

        private int mValue;

        private Block(int value) {
            this.mValue = value;
        }

        public int getValue() {
            return this.mValue;
        }

        public short getReadIndex() {
            return (short)Integer.rotateLeft(this.mValue, 8);
        }

        public short getWriteIndex() {
            return (short)(this.getReadIndex() | 0x10);
        }
    }

    public static enum Address {
        USB_SYSCTL(8192),
        USB_CTRL(8208),
        USB_STAT(8212),
        USB_EPA_CFG(8516),
        USB_EPA_CTL(8520),
        USB_EPA_MAXPKT(8536),
        USB_EPA_MAXPKT_2(8538),
        USB_EPA_FIFO_CFG(8544),
        DEMOD_CTL(12288),
        GPO(12289),
        GPI(12290),
        GPOE(12291),
        GPD(12292),
        SYSINTE(12293),
        SYSINTS(12294),
        GP_CFG0(12295),
        GP_CFG1(12296),
        SYSINTE_1(12297),
        SYSINTS_1(12298),
        DEMOD_CTL_1(12299),
        IR_SUSPEND(12300),
        EEPROM(160);

        private int mAddress;

        private Address(int address) {
            this.mAddress = address;
        }

        public short getAddress() {
            return (short)this.mAddress;
        }
    }

    public class Descriptor {
        private byte[] mData;
        private ArrayList<String> mLabels = new ArrayList();

        public Descriptor(RTL2832TunerController this$0, byte[] data) {
            if (data != null) {
                this.mData = data;
            } else {
                data = new byte[256];
            }
            this.getLabels();
        }

        public boolean isRtlSdrV4() {
            return "RTLSDRBlog".equals(this.getVendorLabel()) && "Blog V4".equals(this.getProductLabel());
        }

        public boolean isValid() {
            return this.mData[0] != 0 && this.mData[1] != 0;
        }

        public String getVendorID() {
            int id = Integer.rotateLeft(0xFF & this.mData[3], 8) | 0xFF & this.mData[2];
            return String.format("%04X", id);
        }

        public String getVendorLabel() {
            return this.mLabels.get(0);
        }

        public String getProductID() {
            int id = Integer.rotateLeft(0xFF & this.mData[5], 8) | 0xFF & this.mData[4];
            return String.format("%04X", id);
        }

        public String getProductLabel() {
            return this.mLabels.get(1);
        }

        public boolean hasSerial() {
            return this.mData[6] == -91;
        }

        public String getSerial() {
            return this.mLabels.get(2);
        }

        public boolean remoteWakeupEnabled() {
            int mask = 1;
            return (this.mData[7] & mask) == mask;
        }

        public boolean irEnabled() {
            int mask = 2;
            return (this.mData[7] & mask) == mask;
        }

        private void getLabels() {
            this.mLabels.clear();
            int start = 9;
            while (start < 256) {
                start = this.getLabel(start);
            }
        }

        private int getLabel(int start) {
            if (start > 254 || this.mData[start + 1] != 3) {
                return 256;
            }
            int length = 0xFF & this.mData[start];
            if (start + length > 255) {
                return 256;
            }
            byte[] data = Arrays.copyOfRange(this.mData, start + 2, start + length);
            String label = new String(data, Charset.forName("UTF-16LE"));
            this.mLabels.add(label);
            return start + length;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("RTL-2832 EEPROM Descriptor\n");
            sb.append("Vendor: ");
            sb.append(this.getVendorID());
            sb.append(" [");
            sb.append(this.getVendorLabel());
            sb.append("]\n");
            sb.append("Product: ");
            sb.append(this.getProductID());
            sb.append(" [");
            sb.append(this.getProductLabel());
            sb.append("]\n");
            sb.append("Serial: ");
            if (this.hasSerial()) {
                sb.append("yes [");
                sb.append(this.getSerial());
                sb.append("]\n");
            } else {
                sb.append("no\n");
            }
            sb.append("Remote Wakeup Enabled: ");
            sb.append(this.remoteWakeupEnabled() ? "yes" : "no");
            sb.append("\n");
            sb.append("IR Enabled: ");
            sb.append(this.irEnabled() ? "yes" : "no");
            sb.append("\n");
            if (this.mLabels.size() > 3) {
                sb.append("Additional Labels: ");
                for (int x = 3; x < this.mLabels.size(); ++x) {
                    sb.append(" [");
                    sb.append(this.mLabels.get(x));
                    sb.append("\n");
                }
            }
            return sb.toString();
        }
    }

    public class ControllerAdapter {
        private RTL2832TunerController mController;

        public ControllerAdapter(RTL2832TunerController this$0, RTL2832TunerController controller) {
            this.mController = controller;
        }

        public boolean isRunning() {
            return this.mController.isRunning();
        }

        public boolean isV4Dongle() {
            return this.mController.getDescriptor().isRtlSdrV4();
        }

        public DeviceHandle getDeviceHandle() {
            return this.mController.getDeviceHandle();
        }

        public ReentrantLock getLock() {
            return this.mController.getLock();
        }

        public void enableI2CRepeater() {
            this.mController.enableI2CRepeater(true);
        }

        public void disableI2CRepeater() {
            this.mController.enableI2CRepeater(false);
        }

        public boolean isI2CRepeaterEnabled() {
            return this.mController.isI2CRepeaterEnabled();
        }

        public void writeDemodRegister(Page page, short address, int value, int length) throws LibUsbException {
            this.mController.writeDemodRegister(page, address, value, length);
        }

        public void writeI2CRegister(byte i2CAddress, byte i2CRegister, byte value, boolean controlI2CRepeater) throws LibUsbException {
            this.mController.writeI2CRegister(i2CAddress, i2CRegister, value, controlI2CRepeater);
        }

        public int readI2CRegister(byte i2CAddress, byte i2CRegister, boolean controlI2CRepeater) throws LibUsbException {
            return this.mController.readI2CRegister(i2CAddress, i2CRegister, controlI2CRepeater);
        }

        public void read(short address, Block block, ByteBuffer buffer) throws LibUsbException {
            this.mController.read(address, block, buffer);
        }

        public void setIFFrequency(int frequency) {
            this.mController.setIFFrequency(frequency);
        }
    }

    public static enum Page {
        ZERO(0),
        ONE(1),
        TEN(10);

        private int mPage;

        private Page(int page) {
            this.mPage = page;
        }

        public byte getPage() {
            return (byte)(this.mPage & 0xFF);
        }
    }

    public static enum TunerTypeCheck {
        E4K(200, 2, 64),
        FC0012(198, 0, 161),
        FC0013(198, 0, 163),
        FC2580(172, 1, 86),
        R820T(52, 0, 105),
        R828D(116, 0, 105);

        private int mI2CAddress;
        private int mCheckAddress;
        private int mCheckValue;

        private TunerTypeCheck(int i2c, int address, int value) {
            this.mI2CAddress = i2c;
            this.mCheckAddress = address;
            this.mCheckValue = value;
        }

        public byte getI2CAddress() {
            return (byte)this.mI2CAddress;
        }

        public byte getCheckAddress() {
            return (byte)this.mCheckAddress;
        }

        public byte getCheckValue() {
            return (byte)this.mCheckValue;
        }
    }

    public static enum SampleMode {
        QUADRATURE,
        DIRECT;

    }
}

