/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.manager;

import io.github.dsheirer.gui.preference.tuner.RspDuoSelectionMode;
import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.source.Source;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.config.SourceConfigTuner;
import io.github.dsheirer.source.config.SourceConfigTunerMultipleFrequency;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.mixer.MixerManager;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.TunerFactory;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.channel.ChannelSpecification;
import io.github.dsheirer.source.tuner.channel.MultiFrequencyTunerChannelSource;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.configuration.TunerConfigurationManager;
import io.github.dsheirer.source.tuner.manager.DiscoveredRecordingTuner;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.DiscoveredUSBTuner;
import io.github.dsheirer.source.tuner.manager.IDiscoveredTunerStatusListener;
import io.github.dsheirer.source.tuner.manager.TunerStatus;
import io.github.dsheirer.source.tuner.recording.RecordingTunerConfiguration;
import io.github.dsheirer.source.tuner.sdrplay.DiscoveredRspTuner;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRPlayException;
import io.github.dsheirer.source.tuner.sdrplay.api.SDRplay;
import io.github.dsheirer.source.tuner.sdrplay.api.device.DeviceInfo;
import io.github.dsheirer.source.tuner.sdrplay.rspDuo.DiscoveredRspDuoTuner1;
import io.github.dsheirer.source.tuner.ui.DiscoveredTunerModel;
import io.github.dsheirer.util.ThreadPool;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceList;
import org.usb4java.HotplugCallback;
import org.usb4java.HotplugCallbackHandle;
import org.usb4java.LibUsb;

public class TunerManager
implements IDiscoveredTunerStatusListener {
    private static final Logger mLog = LoggerFactory.getLogger(TunerManager.class);
    private UserPreferences mUserPreferences;
    private DiscoveredTunerModel mDiscoveredTunerModel = new DiscoveredTunerModel();
    private TunerConfigurationManager mTunerConfigurationManager;
    private HotplugEventSupport mHotplugEventSupport = new HotplugEventSupport();
    private Context mLibUsbApplicationContext = new Context();
    private boolean mLibUsbInitialized = false;
    private SDRplay mSDRplay;

    public TunerManager(UserPreferences userPreferences) {
        this.mUserPreferences = userPreferences;
        this.mTunerConfigurationManager = new TunerConfigurationManager(userPreferences);
    }

    public DiscoveredTunerModel getDiscoveredTunerModel() {
        return this.mDiscoveredTunerModel;
    }

    public TunerConfigurationManager getTunerConfigurationManager() {
        return this.mTunerConfigurationManager;
    }

    public void start() {
        mLog.info("Discovering tuners ...");
        int api = LibUsb.getApiVersion();
        mLog.info("LibUsb API Version: " + (api >> 24 & 0xFF) + "." + (api >> 16 & 0xFF) + "." + (api & 0xFFFF));
        mLog.info("LibUsb Version: " + String.valueOf(LibUsb.getVersion()));
        try {
            int status = LibUsb.init((Context)this.mLibUsbApplicationContext);
            if (status == 0) {
                this.mLibUsbInitialized = true;
                this.discoverUSBTuners();
            }
        }
        catch (Exception e) {
            mLog.error("Error initializing LibUsb and usb4java library", (Throwable)e);
        }
        if (this.mLibUsbInitialized) {
            this.mHotplugEventSupport.start();
        }
        this.discoverSdrPlayTuners();
        this.discoverRecordingTuners();
    }

    public void stop() {
        this.mDiscoveredTunerModel.releaseDiscoveredTuners();
        if (this.mSDRplay != null) {
            this.mSDRplay.close();
            this.mSDRplay = null;
        }
        if (this.mLibUsbInitialized) {
            this.mHotplugEventSupport.stop();
            LibUsb.exit((Context)this.mLibUsbApplicationContext);
            this.mLibUsbInitialized = false;
        }
    }

    public void saveConfigurations() {
        this.mTunerConfigurationManager.saveConfigurations();
    }

    private void discoverUSBTuners() {
        if (this.mLibUsbInitialized) {
            ArrayList<DiscoveredUSBTuner> discoveredUSBTuners = new ArrayList<DiscoveredUSBTuner>();
            try {
                DeviceList deviceList = new DeviceList();
                int deviceCount = LibUsb.getDeviceList((Context)this.mLibUsbApplicationContext, (DeviceList)deviceList);
                if (deviceCount >= 0) {
                    mLog.info("LibUsb - discovered [" + deviceCount + "] potential usb devices");
                    for (Device device : deviceList) {
                        int bus = LibUsb.getBusNumber((Device)device);
                        int port = LibUsb.getPortNumber((Device)device);
                        if (port > 0) {
                            DeviceDescriptor deviceDescriptor = new DeviceDescriptor();
                            int status = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)deviceDescriptor);
                            if (status == 0) {
                                TunerClass tunerClass = TunerClass.lookup(deviceDescriptor.idVendor(), deviceDescriptor.idProduct());
                                String portAddress = TunerManager.getPortAddress(device);
                                if (tunerClass.isSupportedUsbTuner()) {
                                    mLog.info("Discovered tuner at USB Bus [" + bus + "] Port [" + portAddress + "] Tuner Class [" + String.valueOf((Object)tunerClass) + "]");
                                    ChannelizerType channelizerType = this.mUserPreferences.getTunerPreference().getChannelizerType();
                                    DiscoveredUSBTuner discoveredUSBTuner = new DiscoveredUSBTuner(tunerClass, bus, portAddress, channelizerType);
                                    discoveredUSBTuners.add(discoveredUSBTuner);
                                }
                            } else {
                                mLog.error("LibUsb - unable to get device descriptor for device on bus [" + bus + "] port [" + port + "] - status [" + status + "] - " + LibUsb.errorName((int)status));
                            }
                        }
                        LibUsb.unrefDevice((Device)device);
                    }
                    LibUsb.freeDeviceList((DeviceList)deviceList, (boolean)false);
                } else if (deviceCount == -99) {
                    try {
                        mLog.info("LibUsb reported error -99 during get device list - increasing logging level and retrying");
                        LibUsb.setOption((Context)this.mLibUsbApplicationContext, (int)0, (int)2);
                        deviceCount = LibUsb.getDeviceList((Context)this.mLibUsbApplicationContext, (DeviceList)deviceList);
                        if (deviceCount >= 0) {
                            mLog.info("LibUsb - get device list count [" + deviceCount + "] during retry");
                            LibUsb.freeDeviceList((DeviceList)deviceList, (boolean)false);
                        } else {
                            mLog.info("LibUsb - get device list reported error [" + deviceCount + "/" + LibUsb.errorName((int)deviceCount) + "] during retry");
                        }
                        LibUsb.setOption((Context)this.mLibUsbApplicationContext, (int)0, (int)0);
                        mLog.info("LibUse - get device list reattempt complete - if additional logging was generated please notify developer");
                    }
                    catch (Exception e) {
                        mLog.info("LibUsb error during get device list reattempt", (Throwable)e);
                    }
                } else {
                    mLog.error("LibUsb - error [" + deviceCount + "/" + LibUsb.errorName((int)deviceCount) + "] during get device list");
                }
            }
            catch (Exception e) {
                mLog.error("LibUsb - error during USB device discovery", (Throwable)e);
            }
            for (DiscoveredUSBTuner discoveredUSBTuner : discoveredUSBTuners) {
                this.addUsbTuner(discoveredUSBTuner);
            }
        }
    }

    private void addUsbTuner(DiscoveredUSBTuner discoveredUSBTuner) {
        if (!this.mDiscoveredTunerModel.hasUsbTuner(discoveredUSBTuner.getBus(), discoveredUSBTuner.getPortAddress())) {
            this.startAndConfigureTuner(discoveredUSBTuner);
        }
    }

    private DiscoveredTuner removeUsbTuner(int bus, String portAddress) {
        return this.mDiscoveredTunerModel.removeUsbTuner(bus, portAddress);
    }

    private void startAndConfigureTuner(DiscoveredTuner discoveredTuner) {
        discoveredTuner.addTunerStatusListener(this);
        if (this.mTunerConfigurationManager.isDisabled(discoveredTuner)) {
            discoveredTuner.setEnabled(false);
            mLog.info("Tuner: " + String.valueOf(discoveredTuner) + " - Added / Disabled");
        } else {
            mLog.info("Tuner: " + String.valueOf(discoveredTuner) + " - Added / Starting ...");
            this.tunerStatusUpdated(discoveredTuner, TunerStatus.DISABLED, TunerStatus.ENABLED);
        }
        this.mDiscoveredTunerModel.addDiscoveredTuner(discoveredTuner);
    }

    private void discoverSdrPlayTuners() {
        ChannelizerType channelizerType = this.mUserPreferences.getTunerPreference().getChannelizerType();
        RspDuoSelectionMode duoSelectionMode = this.mUserPreferences.getTunerPreference().getRspDuoTunerMode();
        try {
            this.mSDRplay = new SDRplay();
        }
        catch (SDRPlayException se) {
            mLog.error("Couldn't load SDRPlay API");
            this.mSDRplay = null;
        }
        if (this.mSDRplay != null && this.mSDRplay.isAvailable()) {
            try {
                List<DeviceInfo> deviceInfos = this.mSDRplay.getDeviceInfos();
                mLog.info("Discovered [" + deviceInfos.size() + "] RSP devices from SDRplay API");
                if (deviceInfos.isEmpty()) {
                    this.mSDRplay.close();
                    this.mSDRplay = null;
                    return;
                }
                for (DeviceInfo deviceInfo : deviceInfos) {
                    List<DiscoveredRspTuner> tuners = TunerFactory.getRspTuners(deviceInfo, channelizerType, duoSelectionMode);
                    for (DiscoveredRspTuner tuner : tuners) {
                        this.startAndConfigureTuner(tuner);
                    }
                }
            }
            catch (SDRPlayException se) {
                mLog.info("Unable to get list of devices from SDRplay API");
            }
        } else {
            if (this.mSDRplay != null) {
                this.mSDRplay.close();
            }
            this.mSDRplay = null;
        }
    }

    private void discoverRecordingTuners() {
        List<TunerConfiguration> tunerConfigurations = this.getTunerConfigurationManager().getTunerConfigurations(TunerType.RECORDING);
        if (tunerConfigurations.size() > 0) {
            mLog.info("Discovered [" + tunerConfigurations.size() + "] recording tuners");
        }
        for (TunerConfiguration tunerConfiguration : tunerConfigurations) {
            if (!(tunerConfiguration instanceof RecordingTunerConfiguration)) continue;
            RecordingTunerConfiguration recordingTunerConfiguration = (RecordingTunerConfiguration)tunerConfiguration;
            DiscoveredRecordingTuner discoveredRecordingTuner = new DiscoveredRecordingTuner(this.mUserPreferences, recordingTunerConfiguration);
            discoveredRecordingTuner.addTunerStatusListener(this);
            discoveredRecordingTuner.setEnabled(false);
            mLog.info("Tuner Added: " + String.valueOf(discoveredRecordingTuner));
            this.mDiscoveredTunerModel.addDiscoveredTuner(discoveredRecordingTuner);
        }
    }

    @Override
    public void tunerStatusUpdated(DiscoveredTuner discoveredTuner, TunerStatus previous, TunerStatus current) {
        DiscoveredRspDuoTuner1 rspDuoTuner1;
        if (current == TunerStatus.ENABLED) {
            discoveredTuner.start();
        }
        if (discoveredTuner instanceof DiscoveredRspDuoTuner1 && (rspDuoTuner1 = (DiscoveredRspDuoTuner1)discoveredTuner).getDeviceInfo().getDeviceSelectionMode().isMasterMode()) {
            String id = rspDuoTuner1.getId();
            id = id.replace("RSPduo Tuner 1", "RSPduo Tuner 2");
            DiscoveredTuner rspDuoTuner2 = this.getDiscoveredTunerModel().getDiscoveredTuner(id);
            if (rspDuoTuner2 != null) {
                if (previous == TunerStatus.ENABLED && current == TunerStatus.DISABLED) {
                    rspDuoTuner2.setEnabled(false);
                } else if (previous == TunerStatus.DISABLED && current == TunerStatus.ENABLED) {
                    rspDuoTuner2.setEnabled(true);
                    rspDuoTuner2.start();
                }
            }
            this.mTunerConfigurationManager.tunerStatusUpdated(rspDuoTuner1, previous, current);
            if (rspDuoTuner2 != null) {
                this.mTunerConfigurationManager.tunerStatusUpdated(rspDuoTuner2, previous, current);
            }
        } else {
            this.mTunerConfigurationManager.tunerStatusUpdated(discoveredTuner, previous, current);
        }
    }

    public DiscoveredTuner getDiscoveredTuner(String preferredTunerName) {
        if (preferredTunerName != null) {
            for (DiscoveredTuner discoveredTuner : this.getDiscoveredTunerModel().getAvailableTuners()) {
                if (!discoveredTuner.isAvailable() || !discoveredTuner.getTuner().getPreferredName().equalsIgnoreCase(preferredTunerName)) continue;
                return discoveredTuner;
            }
        }
        return null;
    }

    public List<String> getPreferredTunerNames() {
        ArrayList<String> preferredNames = new ArrayList<String>();
        List<DiscoveredTuner> availableTuners = this.getAvailableTuners();
        for (DiscoveredTuner discoveredTuner : availableTuners) {
            String preferredName = discoveredTuner.getTuner().getPreferredName();
            if (preferredNames.contains(preferredName)) continue;
            preferredNames.add(preferredName);
        }
        Collections.sort(preferredNames);
        return preferredNames;
    }

    public List<DiscoveredTuner> getAvailableTuners() {
        return this.mDiscoveredTunerModel.getAvailableTuners();
    }

    public Source getSource(SourceConfiguration config, ChannelSpecification channelSpecification) throws SourceException {
        Source retVal = null;
        switch (config.getSourceType()) {
            case MIXER: {
                retVal = MixerManager.getSource(config);
                break;
            }
            case TUNER: {
                if (!(config instanceof SourceConfigTuner)) break;
                SourceConfigTuner sourceConfigTuner = (SourceConfigTuner)config;
                TunerChannel tunerChannel = sourceConfigTuner.getTunerChannel(channelSpecification.getBandwidth());
                String preferredTuner = sourceConfigTuner.getPreferredTuner();
                retVal = this.getSource(tunerChannel, channelSpecification, preferredTuner);
                break;
            }
            case TUNER_MULTIPLE_FREQUENCIES: {
                String preferredTuner;
                SourceConfigTunerMultipleFrequency sourceConfigTuner;
                TunerChannel tunerChannel;
                Source source;
                if (!(config instanceof SourceConfigTunerMultipleFrequency) || !((source = this.getSource(tunerChannel = (sourceConfigTuner = (SourceConfigTunerMultipleFrequency)config).getTunerChannel(channelSpecification.getBandwidth()), channelSpecification, preferredTuner = sourceConfigTuner.getPreferredTuner())) instanceof TunerChannelSource)) break;
                retVal = new MultiFrequencyTunerChannelSource(this, (TunerChannelSource)source, sourceConfigTuner.getFrequencies(), channelSpecification, sourceConfigTuner.getPreferredTuner());
                break;
            }
        }
        return retVal;
    }

    public Source getSource(TunerChannel tunerChannel, ChannelSpecification channelSpecification, String preferredTuner) {
        TunerChannelSource source = null;
        if (tunerChannel != null && channelSpecification != null) {
            DiscoveredTuner discoveredTuner;
            if (preferredTuner != null) {
                discoveredTuner = this.getDiscoveredTuner(preferredTuner);
                if (discoveredTuner != null) {
                    try {
                        source = discoveredTuner.getTuner().getChannelSourceManager().getSource(tunerChannel, channelSpecification);
                        if (source != null) {
                            return source;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                mLog.info("Unable to source channel [" + tunerChannel.getFrequency() + "] from preferred tuner [" + preferredTuner + "] - searching for another tuner");
            }
            Iterator<DiscoveredTuner> it = this.mDiscoveredTunerModel.getAvailableTuners().iterator();
            while (it.hasNext() && source == null) {
                discoveredTuner = it.next();
                if (!discoveredTuner.hasTuner()) continue;
                try {
                    source = discoveredTuner.getTuner().getChannelSourceManager().getSource(tunerChannel, channelSpecification);
                }
                catch (Exception e) {
                    mLog.error("Error obtaining channel from tuner [" + discoveredTuner.getTuner().getPreferredName() + "]", (Throwable)e);
                }
            }
        }
        return source;
    }

    public static String getPortAddress(Device device) {
        ByteBuffer portNumberArray = ByteBuffer.allocateDirect(7);
        int portCount = LibUsb.getPortNumbers((Device)device, (ByteBuffer)portNumberArray);
        portNumberArray.rewind();
        StringBuilder sb = new StringBuilder();
        for (int x = 0; x < portCount; ++x) {
            if (x > 0) {
                sb.append(".");
            }
            sb.append(portNumberArray.get());
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        mLog.info("Starting ...");
        UserPreferences userPreferences = new UserPreferences();
        TunerManager tunerManager = new TunerManager(userPreferences);
        tunerManager.start();
        while (true) {
            // Infinite loop
        }
    }

    public class HotplugEventSupport
    implements HotplugCallback {
        private static final int HOTPLUG_CONTINUE_EVENT_SUPPORT = 0;
        private HotplugCallbackHandle mHotplugCallbackHandle;
        private ScheduledFuture<?> mEventProcessorFuture;

        public int processEvent(Context context, Device device, int event, Object userData) {
            int bus = LibUsb.getBusNumber((Device)device);
            int port = LibUsb.getPortNumber((Device)device);
            if (port > 0) {
                String portAddress = TunerManager.getPortAddress(device);
                switch (event) {
                    case 1: {
                        TunerClass tunerClass;
                        DeviceDescriptor deviceDescriptor = new DeviceDescriptor();
                        int status = LibUsb.getDeviceDescriptor((Device)device, (DeviceDescriptor)deviceDescriptor);
                        if (status != 0 || !(tunerClass = TunerClass.lookup(deviceDescriptor.idVendor(), deviceDescriptor.idProduct())).isSupportedUsbTuner()) break;
                        mLog.info("Tuner plug-in detected at USB Bus [" + bus + "] Port [" + port + "] Tuner Class [" + String.valueOf((Object)tunerClass) + "]");
                        ChannelizerType channelizerType = TunerManager.this.mUserPreferences.getTunerPreference().getChannelizerType();
                        DiscoveredUSBTuner discoveredUSBTuner = new DiscoveredUSBTuner(tunerClass, bus, portAddress, channelizerType);
                        if (tunerClass.isFuncubeTuner()) {
                            ThreadPool.SCHEDULED.schedule(() -> TunerManager.this.addUsbTuner(discoveredUSBTuner), 2L, TimeUnit.SECONDS);
                            break;
                        }
                        TunerManager.this.addUsbTuner(discoveredUSBTuner);
                        break;
                    }
                    case 2: {
                        DiscoveredTuner removed = TunerManager.this.removeUsbTuner(bus, portAddress);
                        if (removed == null) break;
                        mLog.info("Tuner Unplugged: " + removed.getId());
                    }
                }
            }
            return 0;
        }

        public void start() {
            if (LibUsb.hasCapability((int)1)) {
                this.mHotplugCallbackHandle = new HotplugCallbackHandle();
                int events = 3;
                int flags = 1;
                int vendorId = -1;
                int productId = -1;
                int deviceClass = -1;
                mLog.info("LibUsb - starting HotPlug detection");
                int status = LibUsb.hotplugRegisterCallback((Context)TunerManager.this.mLibUsbApplicationContext, (int)events, (int)flags, (int)vendorId, (int)productId, (int)deviceClass, (HotplugCallback)this, (Object)"sdrtrunk hotplug support", (HotplugCallbackHandle)this.mHotplugCallbackHandle);
                if (status == 0) {
                    Runnable eventHandler = () -> LibUsb.handleEvents((Context)TunerManager.this.mLibUsbApplicationContext);
                    this.mEventProcessorFuture = ThreadPool.SCHEDULED.scheduleAtFixedRate(eventHandler, 0L, 1L, TimeUnit.SECONDS);
                } else {
                    this.mHotplugCallbackHandle = null;
                    mLog.info("LibUsb - unable to register device hotplug listener - " + LibUsb.errorName((int)status));
                }
            } else {
                mLog.info("LibUsb Hotplug event notification Is Not Supported on this platform.");
            }
        }

        public void stop() {
            if (this.mHotplugCallbackHandle != null) {
                LibUsb.hotplugDeregisterCallback((Context)TunerManager.this.mLibUsbApplicationContext, (HotplugCallbackHandle)this.mHotplugCallbackHandle);
                this.mHotplugCallbackHandle = null;
            }
            if (this.mEventProcessorFuture != null) {
                this.mEventProcessorFuture.cancel(true);
                this.mEventProcessorFuture = null;
            }
        }
    }
}

