/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.manager;

import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import java.util.SortedSet;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CenterFrequencyCalculator {
    private static final Logger mLog = LoggerFactory.getLogger(CenterFrequencyCalculator.class);
    public static final long INVALID_FREQUENCY = -1L;

    public static long getCenterFrequency(TunerController tunerController, SortedSet<TunerChannel> channels) {
        long candidateFrequency = -1L;
        boolean isValidCandidateFrequency = true;
        if (channels.size() == 1) {
            candidateFrequency = channels.first().getMinFrequency() - (long)tunerController.getMiddleUnusableHalfBandwidth() + 1L;
        } else {
            long minChannelFrequency = channels.first().getMinFrequency();
            long maxChannelFrequency = channels.last().getMaxFrequency();
            candidateFrequency = maxChannelFrequency - (long)(tunerController.getUsableBandwidth() / 2);
            if (maxChannelFrequency - minChannelFrequency <= (long)tunerController.getUsableHalfBandwidth()) {
                candidateFrequency = minChannelFrequency - (long)tunerController.getMiddleUnusableHalfBandwidth();
                isValidCandidateFrequency = true;
            } else if (tunerController.getMiddleUnusableHalfBandwidth() > 0) {
                boolean processingRequired = true;
                block0: while (isValidCandidateFrequency && processingRequired) {
                    processingRequired = false;
                    long minAvoid = candidateFrequency - (long)tunerController.getMiddleUnusableHalfBandwidth();
                    long maxAvoid = candidateFrequency + (long)tunerController.getMiddleUnusableHalfBandwidth();
                    for (TunerChannel channel : channels) {
                        if (!channel.overlaps(minAvoid, maxAvoid)) continue;
                        long adjustment = channel.getMaxFrequency() - minAvoid + 1L;
                        if (candidateFrequency + adjustment - (long)(tunerController.getUsableBandwidth() / 2) <= minChannelFrequency) {
                            candidateFrequency += adjustment;
                            processingRequired = true;
                            continue block0;
                        }
                        isValidCandidateFrequency = false;
                        continue block0;
                    }
                }
            }
        }
        if (isValidCandidateFrequency) {
            return candidateFrequency;
        }
        return -1L;
    }

    public static boolean canTune(TunerChannel channel, TunerController tunerController, SortedSet<TunerChannel> channels) {
        if (tunerController.getMinimumFrequency() < channel.getMinFrequency() && tunerController.getMaximumFrequency() > channel.getMaxFrequency()) {
            if (channels.isEmpty()) {
                return true;
            }
            TreeSet<TunerChannel> allChannels = new TreeSet<TunerChannel>();
            for (TunerChannel tunerChannel : channels) {
                if (tunerChannel != null) {
                    allChannels.add(tunerChannel);
                    continue;
                }
                mLog.error("Null tuner channel encountered - continuing");
            }
            allChannels.add(channel);
            if (((TunerChannel)allChannels.last()).getMaxFrequency() - ((TunerChannel)allChannels.first()).getMinFrequency() <= (long)tunerController.getUsableBandwidth()) {
                return CenterFrequencyCalculator.getCenterFrequency(tunerController, allChannels) != -1L;
            }
        }
        return false;
    }
}

