/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.hackrf;

import io.github.dsheirer.preference.source.ChannelizerType;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.hackrf.HackRFTunerController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HackRFTuner
extends Tuner {
    private static final Logger mLog = LoggerFactory.getLogger(HackRFTuner.class);

    public HackRFTuner(HackRFTunerController controller, ITunerErrorListener tunerErrorListener, ChannelizerType channelizerType) {
        super(controller, tunerErrorListener, channelizerType);
    }

    @Override
    public String getPreferredName() {
        try {
            HackRFTunerController.Serial serial = this.getController().getSerial();
            return "HackRF " + String.valueOf((Object)this.getController().getTunerType()) + " " + serial.getSerialNumber();
        }
        catch (Exception exception) {
            return "HackRF " + String.valueOf((Object)this.getController().getTunerType());
        }
    }

    public HackRFTunerController getController() {
        return (HackRFTunerController)this.getTunerController();
    }

    @Override
    public TunerClass getTunerClass() {
        return TunerClass.HACKRF;
    }

    @Override
    public double getSampleSize() {
        return 11.0;
    }

    @Override
    public String getUniqueID() {
        try {
            return this.getTunerClass().toString() + " " + this.getController().getSerial().getSerialNumber();
        }
        catch (Exception e) {
            mLog.error("error gettting serial number", (Throwable)e);
            return HackRFTunerController.BoardID.HACKRF_ONE.getLabel();
        }
    }

    @Override
    public int getMaximumUSBBitsPerSecond() {
        return 320000000;
    }
}

