/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.fcd.proplusV2;

import io.github.dsheirer.preference.UserPreferences;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.fcd.FCDTuner;
import io.github.dsheirer.source.tuner.fcd.proplusV2.FCD2TunerConfiguration;
import io.github.dsheirer.source.tuner.fcd.proplusV2.FCD2TunerController;
import io.github.dsheirer.source.tuner.manager.DiscoveredTuner;
import io.github.dsheirer.source.tuner.manager.TunerManager;
import io.github.dsheirer.source.tuner.ui.TunerEditor;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FCD2TunerEditor
extends TunerEditor<FCDTuner, FCD2TunerConfiguration> {
    private static final Logger mLog = LoggerFactory.getLogger(FCD2TunerEditor.class);
    private static final long serialVersionUID = 1L;
    private JButton mTunerInfoButton;
    private JCheckBox mLnaGainCheckBox;
    private JCheckBox mMixerGainCheckBox;

    public FCD2TunerEditor(UserPreferences userPreferences, TunerManager tunerManager, DiscoveredTuner discoveredTuner) {
        super(userPreferences, tunerManager, discoveredTuner);
        this.init();
        this.tunerStatusUpdated();
    }

    private FCD2TunerController getController() {
        if (this.hasTuner()) {
            return (FCD2TunerController)((FCDTuner)this.getTuner()).getController();
        }
        return null;
    }

    @Override
    protected void tunerStatusUpdated() {
        this.setLoading(true);
        if (this.hasTuner()) {
            this.getTunerIdLabel().setText(((FCDTuner)this.getTuner()).getPreferredName());
        } else {
            this.getTunerIdLabel().setText(this.getDiscoveredTuner().getId());
        }
        Object status = this.getDiscoveredTuner().getTunerStatus().toString();
        if (this.getDiscoveredTuner().hasErrorMessage()) {
            status = (String)status + " - " + this.getDiscoveredTuner().getErrorMessage();
        }
        this.getTunerStatusLabel().setText((String)status);
        this.getButtonPanel().updateControls();
        this.getFrequencyPanel().updateControls();
        this.getTunerInfoButton().setEnabled(this.hasTuner());
        this.getLnaGainCheckBox().setEnabled(this.hasTuner());
        this.getMixerGainCheckBox().setEnabled(this.hasTuner());
        if (this.hasTuner() && this.hasConfiguration()) {
            this.getLnaGainCheckBox().setSelected(((FCD2TunerConfiguration)this.getConfiguration()).getGainLNA());
            this.getMixerGainCheckBox().setSelected(((FCD2TunerConfiguration)this.getConfiguration()).getGainMixer());
        }
        this.setLoading(false);
    }

    private void init() {
        this.setLayout((LayoutManager)new MigLayout("fill,wrap 3", "[right][grow,fill][fill]", "[][][][][][][][][][grow]"));
        this.add(new JLabel("Tuner:"));
        this.add(this.getTunerIdLabel());
        this.add(this.getTunerInfoButton());
        this.add(new JLabel("Status:"));
        this.add((Component)this.getTunerStatusLabel(), "wrap");
        this.add((Component)this.getButtonPanel(), "span,align left");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(new JLabel("Frequency (MHz):"));
        this.add((Component)this.getFrequencyPanel(), "wrap");
        this.add((Component)new JSeparator(), "span,growx,push");
        this.add(this.getLnaGainCheckBox());
        this.add(this.getMixerGainCheckBox());
    }

    public JButton getTunerInfoButton() {
        if (this.mTunerInfoButton == null) {
            this.mTunerInfoButton = new JButton("Tuner Info");
            this.mTunerInfoButton.setEnabled(false);
            this.mTunerInfoButton.addActionListener(e -> JOptionPane.showMessageDialog(this, this.getTunerInfo(), "Tuner Info", 1));
        }
        return this.mTunerInfoButton;
    }

    public JCheckBox getLnaGainCheckBox() {
        if (this.mLnaGainCheckBox == null) {
            this.mLnaGainCheckBox = new JCheckBox("LNA Gain");
            this.mLnaGainCheckBox.setEnabled(false);
            this.mLnaGainCheckBox.addActionListener(event -> {
                if (!this.isLoading()) {
                    try {
                        this.getController().setLNAGain(this.getLnaGainCheckBox().isSelected());
                        this.save();
                    }
                    catch (SourceException e) {
                        mLog.error("Couldn't set LNA gain for FCD2", (Throwable)e);
                    }
                }
            });
        }
        return this.mLnaGainCheckBox;
    }

    public JCheckBox getMixerGainCheckBox() {
        if (this.mMixerGainCheckBox == null) {
            this.mMixerGainCheckBox = new JCheckBox("Mixer Gain");
            this.mMixerGainCheckBox.setEnabled(false);
            this.mMixerGainCheckBox.addActionListener(event -> {
                if (!this.isLoading()) {
                    try {
                        this.getController().setMixerGain(this.getMixerGainCheckBox().isSelected());
                        this.save();
                    }
                    catch (SourceException e) {
                        mLog.error("Couldn't set mixer gain for FCD2", (Throwable)e);
                    }
                }
            });
        }
        return this.mMixerGainCheckBox;
    }

    @Override
    public void setTunerLockState(boolean locked) {
        this.getFrequencyPanel().updateControls();
    }

    private String getTunerInfo() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><h3>Funcube Dongle Pro Plus Tuner</h3>");
        if (this.hasTuner()) {
            sb.append("<b>USB ID: </b>");
            sb.append(this.getController().getUSBID());
            sb.append("<br>");
            sb.append("<b>USB Address: </b>");
            sb.append(this.getController().getUSBAddress());
            sb.append("<br>");
            sb.append("<b>USB Speed: </b>");
            sb.append(this.getController().getUSBSpeed());
            sb.append("<br>");
            sb.append("<b>Cellular Band: </b>");
            sb.append((Object)this.getController().getConfiguration().getBandBlocking());
            sb.append("<br>");
            sb.append("<b>Firmware: </b>");
            sb.append(this.getController().getConfiguration().getFirmware());
            sb.append("<br>");
        }
        return sb.toString();
    }

    @Override
    public void save() {
        if (this.hasConfiguration() && !this.isLoading()) {
            ((FCD2TunerConfiguration)this.getConfiguration()).setFrequency(this.getFrequencyControl().getFrequency());
            double value = ((SpinnerNumberModel)this.getFrequencyCorrectionSpinner().getModel()).getNumber().doubleValue();
            ((FCD2TunerConfiguration)this.getConfiguration()).setFrequencyCorrection(value);
            ((FCD2TunerConfiguration)this.getConfiguration()).setAutoPPMCorrectionEnabled(this.getAutoPPMCheckBox().isSelected());
            ((FCD2TunerConfiguration)this.getConfiguration()).setGainLNA(this.getLnaGainCheckBox().isSelected());
            ((FCD2TunerConfiguration)this.getConfiguration()).setGainMixer(this.getMixerGainCheckBox().isSelected());
            this.saveConfiguration();
        }
    }
}

