/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.fcd.proV1;

import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.ITunerErrorListener;
import io.github.dsheirer.source.tuner.MixerTunerType;
import io.github.dsheirer.source.tuner.TunerClass;
import io.github.dsheirer.source.tuner.TunerType;
import io.github.dsheirer.source.tuner.configuration.TunerConfiguration;
import io.github.dsheirer.source.tuner.fcd.FCDCommand;
import io.github.dsheirer.source.tuner.fcd.FCDTunerController;
import io.github.dsheirer.source.tuner.fcd.proV1.FCD1TunerConfiguration;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import javax.sound.sampled.TargetDataLine;
import javax.usb.UsbClaimException;
import javax.usb.UsbException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FCD1TunerController
extends FCDTunerController {
    private static final Logger mLog = LoggerFactory.getLogger(FCD1TunerController.class);
    public static final int MINIMUM_TUNABLE_FREQUENCY = 64000000;
    public static final int MAXIMUM_TUNABLE_FREQUENCY = 1700000000;
    public static final int SAMPLE_RATE = 96000;
    private double mDCCorrectionInPhase = 0.0;
    private double mDCCorrectionQuadrature = 0.0;
    private double mPhaseCorrection = 0.0;
    private double mGainCorrection = 0.0;
    private LNAGain mLNAGain;
    private LNAEnhance mLNAEnhance;
    private MixerGain mMixerGain;

    public FCD1TunerController(TargetDataLine mixerTDL, int bus, String portAddress, ITunerErrorListener tunerErrorListener) {
        super(MixerTunerType.FUNCUBE_DONGLE_PRO, mixerTDL, bus, portAddress, 64000000, 1700000000, tunerErrorListener);
    }

    @Override
    protected void deviceStart() throws SourceException {
        this.mFrequencyController.setSampleRate(96000);
        try {
            this.setFCDMode(FCDTunerController.Mode.APPLICATION);
            this.getPhaseAndGainCorrection();
            this.getDCIQCorrection();
            this.getLNAGainSetting();
            this.getLNAEnhanceSetting();
            this.getMixerGainSetting();
            this.send(FCDCommand.APP_SET_MIXER_GAIN, 1L);
        }
        catch (Exception e) {
            throw new SourceException("FCDTunerController error during construction", e);
        }
    }

    @Override
    public double getCurrentSampleRate() {
        return 96000.0;
    }

    @Override
    public TunerClass getTunerClass() {
        return TunerClass.FUNCUBE_DONGLE_PRO;
    }

    @Override
    public TunerType getTunerType() {
        return TunerType.FUNCUBE_DONGLE_PRO;
    }

    @Override
    public void apply(TunerConfiguration tunerConfig) throws SourceException {
        super.apply(tunerConfig);
        if (tunerConfig instanceof FCD1TunerConfiguration) {
            FCD1TunerConfiguration fcd1 = (FCD1TunerConfiguration)tunerConfig;
            try {
                this.setLNAGain(fcd1.getLNAGain());
                this.setLNAEnhance(fcd1.getLNAEnhance());
                this.setMixerGain(fcd1.getMixerGain());
                this.setDCCorrectionInPhase(fcd1.getInphaseDCCorrection());
                this.setDCCorrectionQuadrature(fcd1.getQuadratureDCCorrection());
                this.setGainCorrection(fcd1.getGainCorrection());
                this.setPhaseCorrection(fcd1.getPhaseCorrection());
            }
            catch (Exception e) {
                throw new SourceException("FCD 1 Controller error applying tuner config - " + e.getLocalizedMessage());
            }
        }
    }

    public LNAGain getLNAGainSetting() throws UsbClaimException, UsbException {
        if (this.mLNAGain == null) {
            ByteBuffer buffer = this.send(FCDCommand.APP_GET_LNA_GAIN);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int gain = buffer.getInt(2);
            this.mLNAGain = LNAGain.valueOf(gain);
        }
        return this.mLNAGain;
    }

    public void setLNAGain(LNAGain gain) throws UsbException, UsbClaimException {
        this.send(FCDCommand.APP_SET_LNA_GAIN, gain.getSetting());
    }

    public double getPhaseCorrection() {
        return this.mPhaseCorrection;
    }

    public void setPhaseCorrection(double value) throws UsbClaimException, UsbException {
        if (value < -1.0 || value > 1.0) {
            throw new IllegalArgumentException("Phase correction value [" + value + "] outside limits ( -1.0 <> 1.0 )");
        }
        this.mPhaseCorrection = value;
        this.setPhaseAndGainCorrection();
    }

    public double getGainCorrection() {
        return this.mGainCorrection;
    }

    public void setGainCorrection(double value) throws UsbClaimException, UsbException {
        if (value < -1.0 || value > 1.0) {
            throw new IllegalArgumentException("Gain correction value [" + value + "] outside limits ( -1.0 <> 1.0 )");
        }
        this.mGainCorrection = value;
        this.setPhaseAndGainCorrection();
    }

    private void setPhaseAndGainCorrection() throws UsbClaimException, UsbException {
        long gain = (long)((1.0 + this.mGainCorrection) * 32767.0);
        long longGain = Long.rotateLeft(0xFFFFL & gain, 16);
        short phase = (short)(this.mPhaseCorrection * 32767.0);
        long correction = longGain | (long)phase;
        this.send(FCDCommand.APP_SET_IQ_CORRECTION, correction);
    }

    private void getPhaseAndGainCorrection() throws UsbClaimException, UsbException {
        ByteBuffer buffer = this.send(FCDCommand.APP_GET_IQ_CORRECTION);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int correction = buffer.getInt(2);
        int gain = (int)Long.rotateRight(correction & 0xFFFF0000, 16);
        this.mGainCorrection = (double)gain / 32767.0 - 1.0;
        short phase = (short)(correction & 0xFFFF);
        this.mPhaseCorrection = (double)phase / 32767.0;
    }

    public double getDCCorrectionInPhase() {
        return this.mDCCorrectionInPhase;
    }

    public void setDCCorrectionInPhase(double value) throws UsbClaimException, UsbException {
        if (value < -1.0 || value > 1.0) {
            throw new IllegalArgumentException("DC inphase correction value [" + value + "] outside limits ( 0.0 <> 1.0 )");
        }
        this.mDCCorrectionInPhase = value;
        this.setDCIQCorrection();
    }

    public double getDCCorrectionQuadrature() {
        return this.mDCCorrectionQuadrature;
    }

    public void setDCCorrectionQuadrature(double value) throws UsbClaimException, UsbException {
        if (value < -1.0 || value > 1.0) {
            throw new IllegalArgumentException("DC quadrature correction value [" + value + "] outside limits ( 0.0 <> 1.0 )");
        }
        this.mDCCorrectionQuadrature = value;
        this.setDCIQCorrection();
    }

    private void setDCIQCorrection() throws UsbClaimException, UsbException {
        short inphase = (short)(this.mDCCorrectionInPhase * 32767.0);
        short quadrature = (short)(this.mDCCorrectionQuadrature * 32767.0);
        long maskedInphase = inphase & 0xFFFF;
        long maskedQuadrature = quadrature & 0xFFFF;
        long shiftedQuadrature = Long.rotateLeft(maskedQuadrature, 16);
        long correction = shiftedQuadrature | maskedInphase;
        this.send(FCDCommand.APP_SET_DC_CORRECTION, correction);
    }

    private void getDCIQCorrection() throws UsbClaimException, UsbException {
        ByteBuffer buffer = this.send(FCDCommand.APP_GET_DC_CORRECTION);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int correction = buffer.getInt(2);
        long shiftedQuadrature = correction & 0xFFFF0000;
        long quadrature = Long.rotateRight(shiftedQuadrature, 16);
        this.mDCCorrectionQuadrature = (double)((short)quadrature) / 32767.0;
        long inphase = correction & 0xFFFF;
        this.mDCCorrectionInPhase = (double)((short)inphase) / 32767.0;
    }

    private void getLNAEnhanceSetting() throws UsbClaimException, UsbException {
        ByteBuffer buffer = this.send(FCDCommand.APP_GET_LNA_ENHANCE);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int enhance = buffer.getInt(2);
        this.mLNAEnhance = LNAEnhance.valueOf(enhance);
    }

    public LNAEnhance getLNAEnhance() {
        return this.mLNAEnhance;
    }

    public void setLNAEnhance(LNAEnhance enhance) throws UsbClaimException, UsbException {
        this.send(FCDCommand.APP_SET_LNA_ENHANCE, enhance.getSetting());
    }

    private void getMixerGainSetting() throws UsbClaimException, UsbException {
        ByteBuffer buffer = this.send(FCDCommand.APP_GET_MIXER_GAIN);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int gain = buffer.getInt(2);
        this.mMixerGain = MixerGain.valueOf(gain);
    }

    public MixerGain getMixerGain() {
        return this.mMixerGain;
    }

    public void setMixerGain(MixerGain gain) throws UsbClaimException, UsbException {
        this.send(FCDCommand.APP_SET_MIXER_GAIN, gain.getSetting());
    }

    public static enum LNAGain {
        LNA_GAIN_MINUS_5_0(0, "-5.0 dB"),
        LNA_GAIN_MINUS_2_5(1, "-2.5 dB"),
        LNA_GAIN_PLUS_0_0(4, "0.0 dB"),
        LNA_GAIN_PLUS_2_5(5, "2.5 dB"),
        LNA_GAIN_PLUS_5_0(6, "5.0 dB"),
        LNA_GAIN_PLUS_7_5(7, "7.5 dB"),
        LNA_GAIN_PLUS_10_0(8, "10.0 dB"),
        LNA_GAIN_PLUS_12_5(9, "12.5 dB"),
        LNA_GAIN_PLUS_15_0(10, "15.0 dB"),
        LNA_GAIN_PLUS_17_5(11, "17.5 dB"),
        LNA_GAIN_PLUS_20_0(12, "20.0 dB"),
        LNA_GAIN_PLUS_25_0(13, "25.0 dB"),
        LNA_GAIN_PLUS_30_0(14, "30.0 dB");

        private int mSetting;
        private String mLabel;

        private LNAGain(int setting, String label) {
            this.mSetting = setting;
            this.mLabel = label;
        }

        public static LNAGain valueOf(int setting) {
            switch (setting) {
                case 0: {
                    return LNA_GAIN_MINUS_5_0;
                }
                case 1: {
                    return LNA_GAIN_MINUS_2_5;
                }
                case 4: {
                    return LNA_GAIN_PLUS_0_0;
                }
                case 5: {
                    return LNA_GAIN_PLUS_2_5;
                }
                case 6: {
                    return LNA_GAIN_PLUS_5_0;
                }
                case 7: {
                    return LNA_GAIN_PLUS_7_5;
                }
                case 8: {
                    return LNA_GAIN_PLUS_10_0;
                }
                case 9: {
                    return LNA_GAIN_PLUS_12_5;
                }
                case 10: {
                    return LNA_GAIN_PLUS_15_0;
                }
                case 11: {
                    return LNA_GAIN_PLUS_17_5;
                }
                case 12: {
                    return LNA_GAIN_PLUS_20_0;
                }
                case 13: {
                    return LNA_GAIN_PLUS_25_0;
                }
                case 14: {
                    return LNA_GAIN_PLUS_30_0;
                }
            }
            throw new IllegalArgumentException("FCD 1.0 Tuner Controller - unrecognized LNA gain setting value [" + setting + "]");
        }

        public int getSetting() {
            return this.mSetting;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.getLabel();
        }
    }

    public static enum LNAEnhance {
        LNA_ENHANCE_OFF(0, "Off"),
        LNA_ENHANCE_0(1, "0"),
        LNA_ENHANCE_1(3, "1"),
        LNA_ENHANCE_2(5, "2"),
        LNA_ENHANCE_3(7, "3");

        private int mSetting;
        private String mLabel;

        private LNAEnhance(int setting, String label) {
            this.mSetting = setting;
            this.mLabel = label;
        }

        public static LNAEnhance valueOf(int setting) {
            switch (setting) {
                case 0: {
                    return LNA_ENHANCE_OFF;
                }
                case 1: {
                    return LNA_ENHANCE_0;
                }
                case 3: {
                    return LNA_ENHANCE_1;
                }
                case 5: {
                    return LNA_ENHANCE_2;
                }
                case 7: {
                    return LNA_ENHANCE_3;
                }
            }
            throw new IllegalArgumentException("FCD 1.0 Tuner Controller - unrecognized LNA enhance setting value [" + setting + "]");
        }

        public int getSetting() {
            return this.mSetting;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.getLabel();
        }
    }

    public static enum MixerGain {
        MIXER_GAIN_PLUS_4_0(0, "4.0 dB"),
        MIXER_GAIN_PLUS_12_0(1, "12.0 dB");

        private int mSetting;
        private String mLabel;

        private MixerGain(int setting, String label) {
            this.mSetting = setting;
            this.mLabel = label;
        }

        public static MixerGain valueOf(int setting) {
            switch (setting) {
                case 0: {
                    return MIXER_GAIN_PLUS_4_0;
                }
                case 1: {
                    return MIXER_GAIN_PLUS_12_0;
                }
            }
            throw new IllegalArgumentException("FCD 1.0 Tuner Controller - unrecognized mixer gain setting value [" + setting + "]");
        }

        public int getSetting() {
            return this.mSetting;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public String toString() {
            return this.getLabel();
        }
    }

    public static enum Block {
        CELLULAR_BAND_BLOCKED("Blocked"),
        NO_BAND_BLOCK("Unblocked"),
        UNKNOWN("Unknown");

        private String mLabel;

        private Block(String label) {
            this.mLabel = label;
        }

        public String getLabel() {
            return this.mLabel;
        }

        public static Block getBlock(String block) {
            Block retVal = UNKNOWN;
            if (block.equalsIgnoreCase("No blk")) {
                retVal = NO_BAND_BLOCK;
            } else if (block.equalsIgnoreCase("Cell blk")) {
                retVal = CELLULAR_BAND_BLOCKED;
            }
            return retVal;
        }
    }
}

