/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.fcd;

public enum FCDCommand {
    BL_QUERY(1, 64),
    BL_RESET(8, 2),
    BL_ERASE(25, 2),
    BL_SET_BYTE_ADDR(26, 6),
    BL_GET_BYTE_ADDR_RANGE(27, 6),
    BL_WRITE_FLASH_BLOCK(28, 52),
    BL_READ_FLASH_BLOCK(29, 48),
    APP_SET_FREQUENCY_KHZ(100, 5),
    APP_SET_FREQUENCY_HZ(101, 6),
    APP_GET_FREQUENCY_HZ(102, 6),
    APP_GET_IF_RSSI(104, 3),
    APP_GET_PLL_LOCKED(105, 3),
    APP_SET_DC_CORRECTION(106, 5),
    APP_GET_DC_CORRECTION(107, 6),
    APP_SET_IQ_CORRECTION(108, 5),
    APP_GET_IQ_CORRECTION(109, 6),
    APP_SET_LNA_GAIN(110, 2),
    APP_SET_LNA_ENHANCE(111, 2),
    APP_SET_BAND(112, 2),
    APP_SET_RF_FILTER(113, 2),
    APP_SET_MIXER_GAIN(114, 2),
    APP_SET_BIAS_CURRENT(115, 2),
    APP_SET_MIXER_FILTER(116, 2),
    APP_SET_IF_GAIN1(117, 2),
    APP_SET_IF_GAIN_MODE(118, 2),
    APP_SET_IF_RC_FILTER(119, 2),
    APP_SET_IF_GAIN2(120, 2),
    APP_SET_IF_GAIN3(121, 2),
    APP_SET_IF_FILTER(122, 2),
    APP_SET_IF_GAIN4(123, 2),
    APP_SET_IF_GAIN5(124, 2),
    APP_SET_IF_GAIN6(125, 2),
    APP_SET_BIAS_TEE(126, 2),
    APP_GET_LNA_GAIN(-106, 3),
    APP_GET_LNA_ENHANCE(-105, 3),
    APP_GET_BAND(-104, 3),
    APP_GET_RF_FILTER(-103, 3),
    APP_GET_MIXER_GAIN(-102, 3),
    APP_GET_BIAS_CURRENT(-101, 3),
    APP_GET_MIXER_FILTER(-100, 3),
    APP_GET_IF_GAIN1(-99, 3),
    APP_GET_IF_GAIN_MODE(-98, 3),
    APP_GET_IF_RC_FILTER(-97, 3),
    APP_GET_IF_GAIN2(-96, 3),
    APP_GET_IF_GAIN3(-95, 3),
    APP_GET_IF_FILTER(-94, 3),
    APP_GET_IF_GAIN4(-93, 3),
    APP_GET_IF_GAIN5(-92, 3),
    APP_GET_IF_GAIN6(-91, 3),
    APP_GET_BIAS_TEE(-90, 3),
    APP_SEND_I2C_BYTE(-56, 2),
    APP_RECV_I2C_BYTE(-55, 3),
    APP_RESET(-1, 1);

    private byte mCommandByte;
    private int mArrayLength;

    private FCDCommand(byte value, int responseLength) {
        this.mCommandByte = value;
        this.mArrayLength = responseLength;
    }

    public byte[] getRequestTemplate() {
        byte[] retVal = new byte[64];
        retVal[0] = this.mCommandByte;
        retVal[1] = 0;
        return retVal;
    }

    public byte[] getResponseTemplate() {
        return new byte[64];
    }

    public byte getCommand() {
        return this.mCommandByte;
    }

    public int getArrayLength() {
        return this.mArrayLength;
    }

    public static boolean checkResponse(FCDCommand command, byte[] response) {
        boolean valid = false;
        if (command != null && response != null) {
            valid = response[0] == command.getCommand() && response[1] == 1;
        }
        return valid;
    }
}

