/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.channel;

import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.source.ComplexSource;
import io.github.dsheirer.source.ISourceEventProcessor;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.SourceEventListenerToProcessorAdapter;
import io.github.dsheirer.source.SourceException;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TunerChannelSource
extends ComplexSource
implements ISourceEventProcessor {
    private static final Logger mLog = LoggerFactory.getLogger(TunerChannelSource.class);
    protected static final long HEARTBEAT_INTERVAL_MS = 100L;
    private SourceEventListenerToProcessorAdapter mConsumerSourceEventListenerAdapter;
    protected TunerChannel mTunerChannel;
    private Listener<SourceEvent> mProducerSourceEventListener;
    private Listener<SourceEvent> mConsumerSourceEventListener;

    public TunerChannelSource(Listener<SourceEvent> producerSourceEventListener, TunerChannel tunerChannel) {
        this.mProducerSourceEventListener = producerSourceEventListener;
        this.mTunerChannel = tunerChannel;
        this.mConsumerSourceEventListenerAdapter = new SourceEventListenerToProcessorAdapter(this);
    }

    @Override
    public long getFrequency() {
        return this.mTunerChannel.getFrequency();
    }

    public void setError(String errorMessage) {
        this.broadcastConsumerSourceEvent(SourceEvent.errorState(this, errorMessage));
    }

    public abstract void setFrequency(long var1);

    protected abstract void setSampleRate(double var1);

    @Override
    public abstract void setListener(Listener<ComplexSamples> var1);

    public TunerChannel getTunerChannel() {
        return this.mTunerChannel;
    }

    @Override
    public void start() {
        this.broadcastConsumerSourceEvent(SourceEvent.frequencyChange(this, this.getFrequency(), "Startup"));
        this.broadcastProducerSourceEvent(SourceEvent.startSampleStreamRequest(this));
    }

    @Override
    public void stop() {
        this.broadcastProducerSourceEvent(SourceEvent.stopSampleStreamRequest(this));
    }

    @Override
    public void reset() {
    }

    protected void performDisposal() {
        this.mProducerSourceEventListener = null;
        this.mConsumerSourceEventListener = null;
        this.mConsumerSourceEventListenerAdapter.dispose();
    }

    @Override
    public void process(SourceEvent sourceEvent) throws SourceException {
        switch (sourceEvent.getEvent()) {
            case NOTIFICATION_FREQUENCY_CHANGE: 
            case NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_LOCKED: 
            case NOTIFICATION_FREQUENCY_AND_SAMPLE_RATE_UNLOCKED: 
            case NOTIFICATION_FREQUENCY_CORRECTION_CHANGE: 
            case NOTIFICATION_PLL_FREQUENCY: 
            case NOTIFICATION_STOP_SAMPLE_STREAM: {
                break;
            }
            case NOTIFICATION_SAMPLE_RATE_CHANGE: {
                this.setSampleRate(sourceEvent.getValue().doubleValue());
                break;
            }
            case NOTIFICATION_MEASURED_FREQUENCY_ERROR: {
                break;
            }
            case NOTIFICATION_MEASURED_FREQUENCY_ERROR_SYNC_LOCKED: {
                sourceEvent.setSource(this);
                this.broadcastProducerSourceEvent(sourceEvent);
                break;
            }
            case NOTIFICATION_FREQUENCY_ROTATION_FAILURE: 
            case NOTIFICATION_FREQUENCY_ROTATION_SUCCESS: 
            case NOTIFICATION_CHANNEL_POWER: 
            case NOTIFICATION_SQUELCH_THRESHOLD: 
            case NOTIFICATION_SQUELCH_AUTO_TRACK: 
            case REQUEST_CHANGE_SQUELCH_THRESHOLD: 
            case REQUEST_CURRENT_SQUELCH_THRESHOLD: 
            case REQUEST_CHANGE_SQUELCH_AUTO_TRACK: 
            case REQUEST_CURRENT_SQUELCH_AUTO_TRACK: {
                break;
            }
            default: {
                mLog.error("Ignoring unrecognized source event: " + String.valueOf((Object)sourceEvent.getEvent()) + " from [" + String.valueOf(sourceEvent.hasSource() ? sourceEvent.getSource().getClass() : "") + "]");
            }
        }
    }

    protected void broadcastProducerSourceEvent(SourceEvent sourceEvent) {
        if (this.mProducerSourceEventListener != null) {
            this.mProducerSourceEventListener.receive(sourceEvent);
        }
    }

    protected void broadcastConsumerSourceEvent(SourceEvent sourceEvent) {
        if (this.mConsumerSourceEventListener != null) {
            this.mConsumerSourceEventListener.receive(sourceEvent);
        }
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return this.mConsumerSourceEventListenerAdapter;
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mConsumerSourceEventListener = listener;
    }

    @Override
    public void removeSourceEventListener() {
        this.mConsumerSourceEventListener = null;
    }
}

