/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner.channel;

import io.github.dsheirer.buffer.INativeBuffer;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.tuner.TunerController;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import io.github.dsheirer.source.tuner.channel.TunerChannelSource;
import io.github.dsheirer.util.Dispatcher;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassThroughChannelSource
extends TunerChannelSource
implements ISourceEventListener,
Listener<INativeBuffer> {
    private static final Logger mLog = LoggerFactory.getLogger(PassThroughChannelSource.class);
    private TunerController mTunerController;
    private Dispatcher<INativeBuffer> mBufferDispatcher;
    private Listener<ComplexSamples> mBufferListener;

    public PassThroughChannelSource(Listener<SourceEvent> listener, TunerController tunerController, TunerChannel tunerChannel) {
        super(listener, tunerChannel);
        this.mTunerController = tunerController;
        this.mBufferDispatcher = new Dispatcher("sdrtrunk pass-through channel " + tunerChannel.getFrequency(), 50L, this.getHeartbeatManager());
        this.mBufferDispatcher.setListener(new BufferProcessor());
    }

    @Override
    public void start() {
        super.start();
        this.mBufferDispatcher.start();
    }

    @Override
    public void stop() {
        super.stop();
        this.mBufferDispatcher.stop();
    }

    @Override
    public void setFrequency(long frequency) {
        mLog.debug("Request to set frequency: " + frequency);
    }

    @Override
    protected void setSampleRate(double sampleRate) {
        mLog.debug("Request to set sample rate: " + sampleRate);
    }

    @Override
    public void setListener(Listener<ComplexSamples> listener) {
        this.mBufferListener = listener;
    }

    @Override
    public double getSampleRate() {
        return this.mTunerController.getSampleRate();
    }

    @Override
    public void receive(INativeBuffer buffer) {
        this.mBufferDispatcher.receive(buffer);
    }

    public class BufferProcessor
    implements Listener<INativeBuffer> {
        @Override
        public void receive(INativeBuffer nativeBuffer) {
            if (PassThroughChannelSource.this.mBufferListener != null) {
                Iterator<ComplexSamples> iterator = nativeBuffer.iterator();
                while (iterator.hasNext()) {
                    try {
                        PassThroughChannelSource.this.mBufferListener.receive(iterator.next());
                    }
                    catch (Throwable t) {
                        mLog.error("Error dispatching complex sample buffers to listener [" + String.valueOf(PassThroughChannelSource.this.mBufferListener) + "]", t);
                    }
                }
            }
        }
    }
}

