/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.tuner;

import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.tuner.Tuner;
import io.github.dsheirer.source.tuner.TunerEvent;
import io.github.dsheirer.util.ThreadPool;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TunerFrequencyErrorMonitor
implements Listener<SourceEvent> {
    private static final Logger mLog = LoggerFactory.getLogger(TunerFrequencyErrorMonitor.class);
    private static final int PROCESSING_INTERVAL_SECONDS = 5;
    private LinkedTransferQueue<Integer> mMeasurementsQueue = new LinkedTransferQueue();
    private List<Integer> mProcessingMeasurements = new ArrayList<Integer>();
    private ScheduledFuture<?> mTimerHandle;
    private Tuner mTuner;

    public TunerFrequencyErrorMonitor(Tuner tuner) {
        this.mTuner = tuner;
    }

    @Override
    public void receive(SourceEvent sourceEvent) {
        if (sourceEvent.getEvent() == SourceEvent.Event.NOTIFICATION_MEASURED_FREQUENCY_ERROR_SYNC_LOCKED) {
            this.mMeasurementsQueue.add(sourceEvent.getValue().intValue());
        }
    }

    private void process() {
        this.mMeasurementsQueue.drainTo(this.mProcessingMeasurements);
        if (this.mProcessingMeasurements.size() > 0) {
            int sum = 0;
            for (Integer measurement : this.mProcessingMeasurements) {
                sum += measurement.intValue();
            }
            this.broadcast(-(sum / this.mProcessingMeasurements.size()));
        } else {
            this.broadcast(0);
        }
        this.mProcessingMeasurements.clear();
    }

    private void broadcast(int averageError) {
        this.mTuner.getTunerController().setMeasuredFrequencyError(averageError);
        this.mTuner.broadcast(new TunerEvent(this.mTuner, TunerEvent.Event.UPDATE_MEASURED_FREQUENCY_ERROR));
    }

    public void start() {
        if (this.mTimerHandle == null) {
            this.mTimerHandle = ThreadPool.SCHEDULED.scheduleAtFixedRate(new Processor(), 0L, 5L, TimeUnit.SECONDS);
        }
    }

    public void stop() {
        if (this.mTimerHandle != null) {
            this.mTimerHandle.cancel(true);
            this.mTimerHandle = null;
            this.broadcast(0);
        }
    }

    public class Processor
    implements Runnable {
        @Override
        public void run() {
            TunerFrequencyErrorMonitor.this.process();
        }
    }
}

