/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.mixer;

import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.adapter.ISampleAdapter;
import io.github.dsheirer.source.RealSource;
import io.github.dsheirer.source.SourceEvent;
import io.github.dsheirer.source.mixer.MixerReader;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.TargetDataLine;

public class RealMixerSource
extends RealSource {
    private long mFrequency;
    private MixerReader mMixerReader;

    public RealMixerSource(TargetDataLine targetDataLine, AudioFormat format, ISampleAdapter sampleAdapter) {
        this.mMixerReader = new MixerReader(format, targetDataLine, sampleAdapter, this.getHeartbeatManager());
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mMixerReader.setSourceEventListener(listener);
    }

    @Override
    public void removeSourceEventListener() {
        this.mMixerReader.removeSourceEventListener();
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return this.mMixerReader.getSourceEventListener();
    }

    @Override
    public void reset() {
        this.stop();
    }

    @Override
    public void start() {
        if (!this.mMixerReader.isRunning()) {
            this.mMixerReader.start();
        }
    }

    @Override
    public void stop() {
        if (this.mMixerReader.isRunning()) {
            this.mMixerReader.stop();
        }
    }

    @Override
    public void setListener(Listener<float[]> listener) {
        this.mMixerReader.setBufferListener(listener);
    }

    public void removeListener(Listener<float[]> listener) {
        this.mMixerReader.removeBufferListener();
    }

    @Override
    public double getSampleRate() {
        return this.mMixerReader.getSampleRate();
    }

    @Override
    public long getFrequency() {
        return this.mFrequency;
    }

    public void setFrequency(long frequency) {
        this.mFrequency = frequency;
    }
}

