/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.source.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import io.github.dsheirer.source.SourceType;
import io.github.dsheirer.source.config.SourceConfiguration;
import io.github.dsheirer.source.tuner.channel.TunerChannel;
import java.util.ArrayList;
import java.util.List;

@JsonSubTypes.Type(value=SourceConfigTunerMultipleFrequency.class, name="sourceConfigTunerMultipleFrequency")
public class SourceConfigTunerMultipleFrequency
extends SourceConfiguration {
    private List<Long> mFrequencies = new ArrayList<Long>();
    private String mPreferredTuner;
    private Long mPreferredFrequency;
    private int mFrequencyRotationDelay = 200;

    public SourceConfigTunerMultipleFrequency() {
        super(SourceType.TUNER_MULTIPLE_FREQUENCIES);
    }

    @JacksonXmlProperty(isAttribute=false, localName="frequency")
    public List<Long> getFrequencies() {
        return this.mFrequencies;
    }

    public void setFrequencies(List<Long> frequencies) {
        this.mFrequencies = frequencies;
    }

    @JsonIgnore
    public boolean hasMultipleFrequencies() {
        return this.mFrequencies.size() > 1;
    }

    @JsonIgnore
    public long getPreferredFrequency() {
        if (this.mPreferredFrequency != null) {
            return this.mPreferredFrequency;
        }
        if (this.mFrequencies.size() > 0) {
            return this.mFrequencies.get(0);
        }
        return 0L;
    }

    public void setPreferredFrequency(long frequency) {
        if (this.mFrequencies.contains(frequency)) {
            this.mPreferredFrequency = frequency;
        }
    }

    public void addFrequency(long frequency) {
        this.mFrequencies.add(frequency);
    }

    @JacksonXmlProperty(isAttribute=true, localName="preferred_tuner")
    public String getPreferredTuner() {
        return this.mPreferredTuner;
    }

    @JsonIgnore
    public boolean hasPreferredTuner() {
        return this.mPreferredTuner != null;
    }

    public void setPreferredTuner(String preferredTuner) {
        this.mPreferredTuner = preferredTuner;
    }

    @Override
    @JsonIgnore
    public String getDescription() {
        return "Frequencies [" + this.mFrequencies.size() + "]";
    }

    @JsonIgnore
    public TunerChannel getTunerChannel(int bandwidth) {
        return new TunerChannel(this.getPreferredFrequency(), bandwidth);
    }

    @JacksonXmlProperty(isAttribute=true, localName="frequency_rotation_delay")
    public int getFrequencyRotationDelay() {
        return this.mFrequencyRotationDelay;
    }

    public void setFrequencyRotationDelay(int frequencyRotationDelay) {
        this.mFrequencyRotationDelay = frequencyRotationDelay < 200 ? 200 : (frequencyRotationDelay > 2000 ? 2000 : frequencyRotationDelay);
    }
}

