/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.settings;

import io.github.dsheirer.settings.ColorSetting;
import io.github.dsheirer.settings.SettingsManager;
import io.github.dsheirer.util.ColorIcon;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JColorChooser;
import javax.swing.JMenuItem;

public class ColorSettingMenuItem
extends JMenuItem {
    private static final long serialVersionUID = 1L;
    private ColorSetting.ColorSettingName mColorSettingName;
    private SettingsManager mSettingsManager;
    private Color mCurrentColor;

    public ColorSettingMenuItem(SettingsManager settingsManager, ColorSetting.ColorSettingName colorSettingName) {
        super(colorSettingName.getLabel());
        this.mSettingsManager = settingsManager;
        this.mColorSettingName = colorSettingName;
        this.mCurrentColor = this.mSettingsManager.getColorSetting(this.mColorSettingName).getColor();
        this.setIcon(new ColorIcon(this.mCurrentColor));
        this.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color newColor = JColorChooser.showDialog(ColorSettingMenuItem.this, ColorSettingMenuItem.this.mColorSettingName.getDialogTitle(), ColorSettingMenuItem.this.mCurrentColor);
                if (newColor != null) {
                    ColorSettingMenuItem.this.mSettingsManager.setColorSetting(ColorSettingMenuItem.this.mColorSettingName, newColor);
                }
            }
        });
    }
}

