/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.sample.complex;

import java.io.Serializable;
import org.apache.commons.math3.util.FastMath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Complex
implements Serializable {
    private static final Logger mLog = LoggerFactory.getLogger(Complex.class);
    private static final long serialVersionUID = 1L;
    private float mLeft;
    private float mRight;

    public Complex(float left, float right) {
        this.mLeft = left;
        this.mRight = right;
    }

    public Complex() {
        this(0.0f, 0.0f);
    }

    public void setInphase(float inphase) {
        this.mLeft = inphase;
    }

    public void setQuadrature(float quadrature) {
        this.mRight = quadrature;
    }

    public void setValues(float inphase, float quadrature) {
        this.mLeft = inphase;
        this.mRight = quadrature;
    }

    public void setValues(Complex sampleToCopy) {
        this.mLeft = sampleToCopy.left();
        this.mRight = sampleToCopy.right();
    }

    public Complex copy() {
        return new Complex(this.mLeft, this.mRight);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("I:");
        sb.append(this.mLeft);
        sb.append(" Q:");
        sb.append(this.mRight);
        return sb.toString();
    }

    public Complex conjugate() {
        return new Complex(this.mLeft, -this.mRight);
    }

    public void multiply(float scalor) {
        this.mLeft *= scalor;
        this.mRight *= scalor;
    }

    public static Complex multiply(Complex sample, float scalor) {
        return new Complex(sample.left() * scalor, sample.right() * scalor);
    }

    public static float multiplyInphase(float inphaseA, float quadratureA, float inphaseB, float quadratureB) {
        return inphaseA * inphaseB - quadratureA * quadratureB;
    }

    public static float multiplyQuadrature(float inphaseA, float quadratureA, float inphaseB, float quadratureB) {
        return quadratureA * inphaseB + inphaseA * quadratureB;
    }

    public void multiply(Complex multiplier) {
        float inphase = Complex.multiplyInphase(this.inphase(), this.quadrature(), multiplier.inphase(), multiplier.quadrature());
        float quadrature = Complex.multiplyQuadrature(this.inphase(), this.quadrature(), multiplier.inphase(), multiplier.quadrature());
        this.mLeft = inphase;
        this.mRight = quadrature;
    }

    public static Complex multiply(Complex sample1, Complex sample2) {
        float inphase = Complex.multiplyInphase(sample1.inphase(), sample1.quadrature(), sample2.inphase(), sample2.quadrature());
        float quadrature = Complex.multiplyQuadrature(sample1.inphase(), sample1.quadrature(), sample2.inphase(), sample2.quadrature());
        return new Complex(inphase, quadrature);
    }

    public static Complex multiply(Complex sample, Float inphase, Float quadrature) {
        float i = Complex.multiplyInphase(sample.inphase(), sample.quadrature(), inphase.floatValue(), quadrature.floatValue());
        float q = Complex.multiplyQuadrature(sample.inphase(), sample.quadrature(), inphase.floatValue(), quadrature.floatValue());
        return new Complex(i, q);
    }

    public static Complex multiply(Float inphase, Float quadrature, Complex sample) {
        float i = Complex.multiplyInphase(inphase.floatValue(), quadrature.floatValue(), sample.inphase(), sample.quadrature());
        float q = Complex.multiplyQuadrature(inphase.floatValue(), quadrature.floatValue(), sample.inphase(), sample.quadrature());
        return new Complex(i, q);
    }

    public static Complex multiply(float inphaseA, float quadratureA, float inphaseB, float quadratureB) {
        float i = Complex.multiplyInphase(inphaseA, quadratureA, inphaseB, quadratureB);
        float q = Complex.multiplyQuadrature(inphaseA, quadratureA, inphaseB, quadratureB);
        return new Complex(i, q);
    }

    public void add(Complex adder) {
        this.mLeft += adder.left();
        this.mRight += adder.right();
    }

    public static Complex add(Complex first, Complex second) {
        return new Complex(first.left() + second.left(), first.right() + second.right());
    }

    public static Complex subtract(Complex first, Complex second) {
        return new Complex(first.left() - second.left(), first.right() - second.right());
    }

    public float magnitude() {
        return (float)FastMath.sqrt((double)this.magnitudeSquared());
    }

    public static float magnitude(float inphase, float quadrature) {
        return (float)FastMath.sqrt((double)(inphase * inphase + quadrature * quadrature));
    }

    public float magnitudeSquared() {
        return this.norm();
    }

    public float norm() {
        return this.inphase() * this.inphase() + this.quadrature() * this.quadrature();
    }

    public void normalize() {
        float magnitude = this.magnitude();
        if (magnitude != 0.0f) {
            this.multiply(1.0f / this.magnitude());
        }
    }

    public void fastNormalize() {
        this.multiply(1.9999f - this.magnitudeSquared());
    }

    public void normalizeFast() {
        float quadratureAbsolute;
        float inphaseAbsolute = FastMath.abs((float)this.inphase());
        float gain = inphaseAbsolute > (quadratureAbsolute = FastMath.abs((float)this.quadrature())) ? 1.0f / (inphaseAbsolute + 0.4f * quadratureAbsolute) : 1.0f / (quadratureAbsolute + 0.4f * inphaseAbsolute);
        this.multiply(gain);
    }

    public float left() {
        return this.mLeft;
    }

    public float right() {
        return this.mRight;
    }

    public float inphase() {
        return this.mLeft;
    }

    public float inPhaseAbsolute() {
        return FastMath.abs((float)this.mLeft);
    }

    public float quadrature() {
        return this.mRight;
    }

    public float quadratureAbsolute() {
        return FastMath.abs((float)this.mRight);
    }

    public float x() {
        return this.mLeft;
    }

    public float y() {
        return this.mRight;
    }

    public float real() {
        return this.mLeft;
    }

    public float realAbsolute() {
        return FastMath.abs((float)this.mLeft);
    }

    public float imaginary() {
        return this.mRight;
    }

    public float imaginaryAbsolute() {
        return FastMath.abs((float)this.mRight);
    }

    public float maximumAbsolute() {
        return FastMath.max((float)FastMath.abs((float)this.mLeft), (float)FastMath.abs((float)this.mRight));
    }

    public static Complex fromAngle(double angle) {
        return new Complex((float)FastMath.cos((double)angle), (float)FastMath.sin((double)angle));
    }

    public void setAngle(double angle) {
        this.setInphase((float)FastMath.cos((double)angle));
        this.setQuadrature((float)FastMath.sin((double)angle));
    }

    public float angle() {
        return (float)FastMath.atan2((double)this.y(), (double)this.x());
    }

    public double angleDegrees() {
        return FastMath.toDegrees((double)FastMath.atan2((double)this.y(), (double)this.x()));
    }

    public double polarAngleDegrees() {
        double angle = FastMath.toDegrees((double)FastMath.atan2((double)this.y(), (double)this.x()));
        return (450.0 - angle) % 360.0;
    }

    public void clip(float value) {
        if (this.mLeft > value) {
            this.mLeft = value;
        } else if (this.mLeft < -value) {
            this.mLeft = -value;
        }
        if (this.mRight > value) {
            this.mRight = value;
        } else if (this.mRight < -value) {
            this.mRight = -value;
        }
    }

    public float polarAngle() {
        return (float)FastMath.toDegrees((double)this.angle());
    }

    public float envelope() {
        return Complex.envelope(this.mLeft, this.mRight);
    }

    public static float envelope(float inphase, float quadrature) {
        float quadratureAbsolute;
        float inphaseAbsolute = FastMath.abs((float)inphase);
        if (inphaseAbsolute > (quadratureAbsolute = FastMath.abs((float)quadrature))) {
            return inphaseAbsolute + 0.4f * quadratureAbsolute;
        }
        return quadratureAbsolute + 0.4f * inphaseAbsolute;
    }
}

