/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.sample;

import io.github.dsheirer.sample.complex.Complex;
import io.github.dsheirer.sample.complex.ComplexSamples;
import java.util.Random;
import org.apache.commons.math3.util.FastMath;

public class SampleUtils {
    public static final double TWO_PI = Math.PI * 2;

    public static ComplexSamples deinterleave(float[] samples, long timestamp) {
        float[] i = new float[samples.length / 2];
        float[] q = new float[samples.length / 2];
        for (int x = 0; x < i.length; ++x) {
            int offset = 2 * x;
            i[x] = samples[offset];
            q[x] = samples[offset + 1];
        }
        return new ComplexSamples(i, q, timestamp);
    }

    public static float[] interleave(ComplexSamples complexSamples) {
        float[] i = complexSamples.i();
        float[] q = complexSamples.q();
        float[] complex = new float[i.length + q.length];
        for (int x = 0; x < i.length; ++x) {
            complex[2 * x] = i[x];
            complex[2 * x + 1] = q[x];
        }
        return complex;
    }

    public static ComplexSamples generateComplex(int count) {
        Random random = new Random();
        float[] i = new float[count];
        float[] q = new float[count];
        for (int x = 0; x < i.length; ++x) {
            double angle = random.nextDouble() * (Math.PI * 2) - Math.PI;
            i[x] = (float)Math.cos(angle);
            q[x] = (float)Math.sin(angle);
        }
        return new ComplexSamples(i, q, System.currentTimeMillis());
    }

    public static ComplexSamples generateComplexRandomVectorLength(int count) {
        Random random = new Random();
        ComplexSamples unitySamples = SampleUtils.generateComplex(count);
        float[] i = unitySamples.i();
        float[] q = unitySamples.q();
        int x = 0;
        while (x < i.length) {
            float gain = 0.5f + random.nextFloat() / 2.0f;
            int n = x;
            i[n] = i[n] * gain;
            int n2 = x++;
            q[n2] = q[n2] * gain;
        }
        return new ComplexSamples(i, q, System.currentTimeMillis());
    }

    public static Complex multiply(Complex a, Complex b) {
        return new Complex(a.inphase() * b.inphase() - a.quadrature() * b.quadrature(), a.quadrature() * b.inphase() + a.inphase() * b.quadrature());
    }

    public static Complex minus(Complex a, Complex b) {
        return new Complex(a.inphase() - b.inphase(), a.quadrature() - b.quadrature());
    }

    public static double magnitude(Complex sample) {
        return FastMath.sqrt((double)SampleUtils.magnitudeSquared(sample));
    }

    public static int magnitudeSquared(Complex sample) {
        return (int)(sample.inphase() * sample.inphase() + sample.quadrature() * sample.quadrature());
    }
}

