/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.playlist;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import io.github.dsheirer.preference.Preference;
import io.github.dsheirer.preference.PreferenceType;
import io.github.dsheirer.preference.directory.DirectoryPreference;
import io.github.dsheirer.sample.Listener;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlaylistPreference
extends Preference {
    private static final Logger mLog = LoggerFactory.getLogger(PlaylistPreference.class);
    private Preferences mPreferences = Preferences.userNodeForPackage(PlaylistPreference.class);
    private static final String FILE_PLAYLIST = "default.xml";
    private static final String FILE_LEGACY_PLAYLIST = "playlist_v2.xml";
    private static final String PREFERENCE_KEY_PLAYLIST = "playlist.path";
    private static final String PREFERENCE_KEY_PLAYLIST_LIST = "playlist.list";
    private Path mPlaylistPath;
    private DirectoryPreference mDirectoryPreference;

    public PlaylistPreference(Listener<PreferenceType> updateListener, DirectoryPreference directoryPreference) {
        super(updateListener);
        this.mDirectoryPreference = directoryPreference;
    }

    @Override
    public PreferenceType getPreferenceType() {
        return PreferenceType.PLAYLIST;
    }

    public Path getPlaylist() {
        if (this.mPlaylistPath == null) {
            this.mPlaylistPath = this.getPath(PREFERENCE_KEY_PLAYLIST, this.getDefaultPlaylistPath());
        }
        return this.mPlaylistPath;
    }

    public Path getLegacyPlaylist() {
        return this.mDirectoryPreference.getDirectoryPlaylist().resolve(FILE_LEGACY_PLAYLIST);
    }

    public Path getPlaylistLock() {
        String playlist = this.getPlaylist().toAbsolutePath().toString();
        return Paths.get(playlist + ".lck", new String[0]);
    }

    public Path getPlaylistBackup() {
        String playlist = this.getPlaylist().toString();
        return Paths.get(playlist + ".backup", new String[0]);
    }

    public void setPlaylist(Path path) {
        this.mPlaylistPath = path;
        this.mPreferences.put(PREFERENCE_KEY_PLAYLIST, path.toString());
        this.notifyPreferenceUpdated();
    }

    private Path getDefaultPlaylistPath() {
        return this.mDirectoryPreference.getDefaultPlaylistDirectory().resolve(FILE_PLAYLIST);
    }

    public List<Path> getPlaylistList() {
        ArrayList<Path> playlists = new ArrayList<Path>();
        String raw = this.mPreferences.get(PREFERENCE_KEY_PLAYLIST_LIST, null);
        if (raw != null && !raw.isEmpty()) {
            for (String rawPath : Splitter.on((String)",").split((CharSequence)raw)) {
                Path path = Paths.get(rawPath, new String[0]);
                if (playlists.contains(path)) continue;
                playlists.add(path);
            }
        }
        boolean hasCurrent = false;
        for (Path path : playlists) {
            if (!path.toString().contentEquals(this.getPlaylist().toString())) continue;
            hasCurrent = true;
        }
        if (!hasCurrent) {
            playlists.add(0, this.getPlaylist());
        }
        return playlists;
    }

    public void setPlaylistList(List<Path> playlistPaths) {
        if (playlistPaths != null && !playlistPaths.isEmpty()) {
            String rawList = Joiner.on((String)",").join(playlistPaths);
            this.mPreferences.put(PREFERENCE_KEY_PLAYLIST_LIST, rawList);
        }
    }

    private Path getPath(String key, Path defaultPath) {
        Path temp;
        String stringPath = this.mPreferences.get(key, defaultPath.toString());
        if (stringPath != null && !stringPath.isEmpty() && Files.exists(temp = Paths.get(stringPath, new String[0]), new LinkOption[0])) {
            return temp;
        }
        return defaultPath;
    }
}

