/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.javafx;

import io.github.dsheirer.preference.decoder.JmbeLibraryPreference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.stage.Screen;
import javafx.stage.Stage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaFxPreferences {
    private static final Logger mLog = LoggerFactory.getLogger(JmbeLibraryPreference.class);
    private static final String PREFERENCE_STAGE_HEIGHT_PREFIX = "stage.height.";
    private static final String PREFERENCE_STAGE_WIDTH_PREFIX = "stage.width.";
    private static final String PREFERENCE_STAGE_X_PREFIX = "stage.x.";
    private static final String PREFERENCE_STAGE_Y_PREFIX = "stage.y.";
    private static final String PREFERENCE_STAGE_MAXIMIZED = "state.maximized";
    private Preferences mPreferences = Preferences.userNodeForPackage(JavaFxPreferences.class);
    private List<StageMonitor> mStageMonitors = new ArrayList<StageMonitor>();

    public void monitor(Stage stage, String key) {
        this.mStageMonitors.add(new StageMonitor(stage, key));
    }

    public void unmonitor(Stage stage) {
        Iterator<StageMonitor> it = this.mStageMonitors.iterator();
        while (it.hasNext()) {
            StageMonitor next = it.next();
            if (!next.equals(stage)) continue;
            it.remove();
            next.dispose();
        }
    }

    public void clearStageMonitors() {
        Iterator<StageMonitor> it = this.mStageMonitors.iterator();
        while (it.hasNext()) {
            StageMonitor next = it.next();
            it.remove();
            next.dispose();
        }
    }

    public class StageMonitor {
        private Stage mStage;
        private String mKey;
        private NumberMonitor mX;
        private NumberMonitor mY;
        private NumberMonitor mHeight;
        private NumberMonitor mWidth;
        private BooleanMonitor mMaximized;

        public StageMonitor(Stage stage, String key) {
            this.mStage = stage;
            this.mKey = key;
            this.reposition(stage);
            this.mX = new NumberMonitor(JavaFxPreferences.PREFERENCE_STAGE_X_PREFIX + key);
            this.mY = new NumberMonitor(JavaFxPreferences.PREFERENCE_STAGE_Y_PREFIX + key);
            this.mHeight = new NumberMonitor(JavaFxPreferences.PREFERENCE_STAGE_HEIGHT_PREFIX + key);
            this.mWidth = new NumberMonitor(JavaFxPreferences.PREFERENCE_STAGE_WIDTH_PREFIX + key);
            this.mMaximized = new BooleanMonitor(JavaFxPreferences.PREFERENCE_STAGE_MAXIMIZED + key);
            this.mStage.xProperty().addListener((ChangeListener)this.mX);
            this.mStage.yProperty().addListener((ChangeListener)this.mY);
            this.mStage.heightProperty().addListener((ChangeListener)this.mHeight);
            this.mStage.widthProperty().addListener((ChangeListener)this.mWidth);
            this.mStage.maximizedProperty().addListener((ChangeListener)this.mMaximized);
        }

        public void dispose() {
            this.mStage.xProperty().removeListener((ChangeListener)this.mX);
            this.mStage.yProperty().removeListener((ChangeListener)this.mY);
            this.mStage.heightProperty().removeListener((ChangeListener)this.mHeight);
            this.mStage.widthProperty().removeListener((ChangeListener)this.mWidth);
            this.mStage.maximizedProperty().removeListener((ChangeListener)this.mMaximized);
            this.mStage = null;
        }

        private void reposition(Stage stage) {
            double x = JavaFxPreferences.this.mPreferences.getDouble(JavaFxPreferences.PREFERENCE_STAGE_X_PREFIX + this.mKey, stage.getX());
            double y = JavaFxPreferences.this.mPreferences.getDouble(JavaFxPreferences.PREFERENCE_STAGE_Y_PREFIX + this.mKey, stage.getY());
            double height = JavaFxPreferences.this.mPreferences.getDouble(JavaFxPreferences.PREFERENCE_STAGE_HEIGHT_PREFIX + this.mKey, stage.getHeight());
            double width = JavaFxPreferences.this.mPreferences.getDouble(JavaFxPreferences.PREFERENCE_STAGE_WIDTH_PREFIX + this.mKey, stage.getWidth());
            boolean maximized = JavaFxPreferences.this.mPreferences.getBoolean(JavaFxPreferences.PREFERENCE_STAGE_MAXIMIZED, stage.isMaximized());
            ObservableList screens = Screen.getScreensForRectangle((double)x, (double)y, (double)width, (double)height);
            if (!screens.isEmpty()) {
                stage.setX(x);
                stage.setY(y);
                stage.setHeight(height);
                stage.setWidth(width);
                stage.setMaximized(maximized);
            }
        }
    }

    public class BooleanMonitor
    implements ChangeListener<Boolean> {
        private String mKey;

        public BooleanMonitor(String key) {
            this.mKey = key;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            JavaFxPreferences.this.mPreferences.putBoolean(this.mKey, newValue);
        }
    }

    public class NumberMonitor
    implements ChangeListener<Number> {
        private String mKey;

        public NumberMonitor(String key) {
            this.mKey = key;
        }

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            if (newValue != null) {
                JavaFxPreferences.this.mPreferences.putDouble(this.mKey, newValue.doubleValue());
            }
        }
    }
}

