/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference.identifier.talkgroup;

import io.github.dsheirer.identifier.talkgroup.TalkgroupIdentifier;
import io.github.dsheirer.module.decode.mpt1327.identifier.MPT1327Talkgroup;
import io.github.dsheirer.preference.identifier.IntegerFormat;
import io.github.dsheirer.preference.identifier.talkgroup.AbstractIntegerFormatter;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MPT1327TalkgroupFormatter
extends AbstractIntegerFormatter {
    private static final Logger mLog = LoggerFactory.getLogger(MPT1327TalkgroupFormatter.class);
    private static final int IDENTIFIER_DECIMAL_WIDTH = 7;
    private static final int IDENTIFIER_HEXADECIMAL_WIDTH = 5;
    private static final int FLEET_DECIMAL_WIDTH = 3;
    private static final int IDENT_DECIMAL_WIDTH = 4;
    private static final String SEPARATOR = "-";
    private static final Pattern MPT1327_PATTERN = Pattern.compile("(\\d{1,3})-(\\d{1,4})");

    public static String format(TalkgroupIdentifier identifier, IntegerFormat format, boolean fixedWidth) {
        if (identifier instanceof MPT1327Talkgroup) {
            MPT1327Talkgroup mpt = (MPT1327Talkgroup)identifier;
            if (fixedWidth) {
                switch (format) {
                    case DECIMAL: {
                        return MPT1327TalkgroupFormatter.toDecimal((Integer)mpt.getValue(), 7);
                    }
                    case FORMATTED: {
                        return MPT1327TalkgroupFormatter.toDecimal(mpt.getPrefix(), 3) + SEPARATOR + MPT1327TalkgroupFormatter.toDecimal(mpt.getIdent(), 4);
                    }
                    case HEXADECIMAL: {
                        return MPT1327TalkgroupFormatter.toHex((Integer)mpt.getValue(), 5);
                    }
                }
                throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
            }
            switch (format) {
                case DECIMAL: {
                    return mpt.toString();
                }
                case FORMATTED: {
                    return mpt.getPrefix() + SEPARATOR + mpt.getIdent();
                }
                case HEXADECIMAL: {
                    return MPT1327TalkgroupFormatter.toHex((Integer)identifier.getValue());
                }
            }
            throw new IllegalArgumentException("Unrecognized integer format: " + String.valueOf((Object)format));
        }
        return identifier.toString();
    }

    @Override
    public int parse(String formattedTalkgroup) throws ParseException {
        Matcher m;
        if (formattedTalkgroup != null && (m = MPT1327_PATTERN.matcher(formattedTalkgroup)).matches()) {
            String rawPrefix = m.group(1);
            String rawIdent = m.group(2);
            try {
                int prefix = Integer.parseInt(rawPrefix);
                if (prefix < 0 || prefix > 127) {
                    throw new ParseException("MPT-1327 prefix must be in range 0-127.  Error parsing [" + formattedTalkgroup + "]", 0);
                }
                int ident = Integer.parseInt(rawIdent);
                if (ident < 1 || ident > 8191) {
                    throw new ParseException("MPT-1327 ident must be in range 1-8192.  Error parsing [" + formattedTalkgroup + "]", 0);
                }
                return (prefix << 13) + ident;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new ParseException("Error parsing MPT1327 talkgroup value [" + formattedTalkgroup + "]", 0);
    }

    @Override
    public String format(int talkgroup) {
        return MPT1327TalkgroupFormatter.toDecimal(MPT1327TalkgroupFormatter.getPrefix(talkgroup), 3) + SEPARATOR + MPT1327TalkgroupFormatter.toDecimal(MPT1327TalkgroupFormatter.getIdent(talkgroup), 4);
    }

    @Override
    public String format(int value, IntegerFormat integerFormat) {
        return this.format(value);
    }

    public static int getPrefix(int talkgroup) {
        return talkgroup >> 13 & 0x7F;
    }

    public static int getIdent(int talkgroup) {
        return talkgroup & 0x1FFF;
    }
}

