/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.preference;

import java.text.SimpleDateFormat;

public enum TimestampFormat {
    TIMESTAMP_DEFAULT("yyyy-MM-dd HH:mm:ss", "Timestamp: yyyy-MM-dd HH:mm:ss"),
    TIMESTAMP_COLONS("yyyy:MM:dd:HH:mm:ss", "Timestamp Colons: yyyy:MM:dd:HH:mm:ss"),
    TIMESTAMP_MILLIS("yyyy:MM:dd:HH:mm:ss.SSS", "Timestamp Milliseconds: yyyy:MM:dd:HH:mm:ss.SSS"),
    TIMESTAMP_COMPACT("yyyyMMdd_HHmmss", "Timestamp Compact: yyyyMMdd_HHmmss"),
    DATE_DASHES("yyyy-MM-dd", "Date Dashes: YYYY-MM-DD"),
    DATE_COLONS("yyyy:MM:dd", "Date Colons: YYYY:MM:DD"),
    DATE_COMPACT("yyyyMMdd", "Date Compact: YYYYMMDD"),
    TIME_COMPACT("HHmmss", "Time Compact: HHmmss"),
    TIME_COLONS("HH:mm:ss", "Time Colons: HH:mm:ss"),
    TIME_MILLIS("HH:mm:ss.SSS", "Time Milliseconds: HH:mm:ss.SSS"),
    TIME_SECONDS("ss.SSS", "Time Seconds: ss.SSS");

    private String mFormat;
    private String mLabel;

    private TimestampFormat(String format, String label) {
        this.mFormat = format;
        this.mLabel = label;
    }

    public String getFormat() {
        return this.mFormat;
    }

    public SimpleDateFormat getFormatter() {
        return new SimpleDateFormat(this.mFormat);
    }

    public String toString() {
        return this.mLabel;
    }
}

