/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.log;

import io.github.dsheirer.alias.AliasList;
import io.github.dsheirer.alias.AliasModel;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Form;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.configuration.AliasListConfigurationIdentifier;
import io.github.dsheirer.identifier.configuration.FrequencyConfigurationIdentifier;
import io.github.dsheirer.module.decode.event.IDecodeEvent;
import io.github.dsheirer.module.decode.event.IDecodeEventListener;
import io.github.dsheirer.module.log.EventLogger;
import io.github.dsheirer.preference.TimestampFormat;
import io.github.dsheirer.sample.Listener;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.QuoteMode;

public class DecodeEventLogger
extends EventLogger
implements IDecodeEventListener,
Listener<IDecodeEvent> {
    private SimpleDateFormat mTimestampFormat = TimestampFormat.TIMESTAMP_COLONS.getFormatter();
    private DecimalFormat mFrequencyFormat = new DecimalFormat("0.000000");
    private AliasList mAliasList;
    private AliasModel mAliasModel;
    private final CSVFormat mCsvFormat = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setQuoteMode(QuoteMode.ALL).build();

    public DecodeEventLogger(AliasModel aliasModel, Path logDirectory, String fileNameSuffix, long frequency) {
        super(logDirectory, fileNameSuffix, frequency);
        this.mAliasModel = aliasModel;
    }

    @Override
    public void receive(IDecodeEvent decodeEvent) {
        this.write(this.toCSV(decodeEvent));
    }

    @Override
    public String getHeader() {
        return DecodeEventLogger.getCSVHeader();
    }

    @Override
    public Listener<IDecodeEvent> getDecodeEventListener() {
        return this;
    }

    @Override
    public void reset() {
    }

    public static String getCSVHeader() {
        return "TIMESTAMP,DURATION_MS,PROTOCOL,EVENT,FROM,TO,CHANNEL_NUMBER,FREQUENCY,TIMESLOT,DETAILS";
    }

    private String toCSV(IDecodeEvent event) {
        ArrayList<Object> cells = new ArrayList<Object>();
        cells.add(this.mTimestampFormat.format(new Date(event.getTimeStart())));
        cells.add(event.getDuration() > 0L ? Long.valueOf(event.getDuration()) : "");
        cells.add((Object)event.getProtocol());
        cells.add((Object)event.getEventType());
        List<Identifier> fromIdentifiers = event.getIdentifierCollection().getIdentifiers(Role.FROM);
        if (fromIdentifiers != null && !fromIdentifiers.isEmpty()) {
            cells.add(fromIdentifiers.get(0));
        } else {
            cells.add("");
        }
        List<Identifier> toIdentifiers = event.getIdentifierCollection().getIdentifiers(Role.TO);
        if (toIdentifiers != null && !toIdentifiers.isEmpty()) {
            Identifier identifier = event.getIdentifierCollection().getIdentifier(IdentifierClass.CONFIGURATION, Form.ALIAS_LIST, Role.ANY);
            this.mAliasList = this.mAliasModel.getAliasList((AliasListConfigurationIdentifier)identifier);
            if (this.mAliasList != null) {
                String mystring = !this.mAliasList.getAliases(toIdentifiers.get(0)).isEmpty() ? this.mAliasList.getAliases(toIdentifiers.get(0)).get(0).toString() : "";
                cells.add(mystring + " (" + String.valueOf(toIdentifiers.get(0)) + ")");
            } else {
                cells.add("");
            }
        } else {
            cells.add("");
        }
        IChannelDescriptor descriptor = event.getChannelDescriptor();
        cells.add(descriptor != null ? descriptor : "");
        Identifier frequency = event.getIdentifierCollection().getIdentifier(IdentifierClass.CONFIGURATION, Form.CHANNEL_FREQUENCY, Role.ANY);
        if (frequency instanceof FrequencyConfigurationIdentifier) {
            cells.add(this.mFrequencyFormat.format((double)((Long)((FrequencyConfigurationIdentifier)frequency).getValue()).longValue() / 1000000.0));
        } else {
            cells.add("");
        }
        if (event.hasTimeslot()) {
            cells.add("TS:" + event.getTimeslot());
        } else {
            cells.add("");
        }
        String details = event.getDetails();
        cells.add(details != null ? details : "");
        return this.mCsvFormat.format(cells.toArray());
    }
}

