/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.demodulate.fm;

import io.github.dsheirer.dsp.filter.FilterFactory;
import io.github.dsheirer.dsp.filter.decimate.DecimationFilterFactory;
import io.github.dsheirer.dsp.filter.decimate.IRealDecimationFilter;
import io.github.dsheirer.dsp.filter.design.FilterDesignException;
import io.github.dsheirer.dsp.filter.fir.FIRFilterSpecification;
import io.github.dsheirer.dsp.filter.fir.real.IRealFilter;
import io.github.dsheirer.dsp.filter.resample.RealResampler;
import io.github.dsheirer.dsp.fm.FmDemodulatorFactory;
import io.github.dsheirer.dsp.fm.IDemodulator;
import io.github.dsheirer.dsp.squelch.PowerMonitor;
import io.github.dsheirer.dsp.window.WindowType;
import io.github.dsheirer.module.Module;
import io.github.dsheirer.sample.Listener;
import io.github.dsheirer.sample.complex.ComplexSamples;
import io.github.dsheirer.sample.complex.IComplexSamplesListener;
import io.github.dsheirer.sample.real.IRealBufferProvider;
import io.github.dsheirer.source.ISourceEventListener;
import io.github.dsheirer.source.ISourceEventProvider;
import io.github.dsheirer.source.SourceEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMDemodulatorModule
extends Module
implements ISourceEventListener,
ISourceEventProvider,
IComplexSamplesListener,
Listener<ComplexSamples>,
IRealBufferProvider {
    private static final Logger mLog = LoggerFactory.getLogger(FMDemodulatorModule.class);
    private static final double DEMODULATED_AUDIO_SAMPLE_RATE = 8000.0;
    private IRealFilter mIBasebandFilter;
    private IRealFilter mQBasebandFilter;
    private IRealDecimationFilter mIDecimationFilter;
    private IRealDecimationFilter mQDecimationFilter;
    private IDemodulator mDemodulator = FmDemodulatorFactory.getFmDemodulator();
    private PowerMonitor mPowerMonitor = new PowerMonitor();
    private RealResampler mResampler;
    private SourceEventProcessor mSourceEventProcessor = new SourceEventProcessor();
    private Listener<float[]> mResampledBufferListener;
    private double mChannelBandwidth;

    public FMDemodulatorModule(double channelBandwidth) {
        this.mChannelBandwidth = channelBandwidth;
    }

    protected void broadcast(float[] demodulatedSamples) {
        if (this.mResampledBufferListener != null) {
            this.mResampledBufferListener.receive(demodulatedSamples);
        }
    }

    @Override
    public Listener<ComplexSamples> getComplexSamplesListener() {
        return this;
    }

    @Override
    public Listener<SourceEvent> getSourceEventListener() {
        return this.mSourceEventProcessor;
    }

    @Override
    public void dispose() {
        this.mDemodulator = null;
    }

    @Override
    public void reset() {
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void setBufferListener(Listener<float[]> listener) {
        this.mResampledBufferListener = listener;
    }

    @Override
    public void removeBufferListener() {
        this.mResampledBufferListener = null;
    }

    @Override
    public void receive(ComplexSamples samples) {
        if (this.mIBasebandFilter == null || this.mIDecimationFilter == null) {
            throw new IllegalStateException("FM demodulator module must receive a sample rate change source event before it can process complex sample buffers");
        }
        float[] decimatedI = this.mIDecimationFilter.decimateReal(samples.i());
        float[] decimatedQ = this.mQDecimationFilter.decimateReal(samples.q());
        float[] filteredI = this.mIBasebandFilter.filter(decimatedI);
        float[] filteredQ = this.mQBasebandFilter.filter(decimatedQ);
        float[] demodulated = this.mDemodulator.demodulate(filteredI, filteredQ);
        this.mPowerMonitor.process(filteredI, filteredQ);
        if (this.mResampler != null) {
            this.mResampler.resample(demodulated);
        }
    }

    @Override
    public void setSourceEventListener(Listener<SourceEvent> listener) {
        this.mPowerMonitor.setSourceEventListener(listener);
    }

    @Override
    public void removeSourceEventListener() {
        this.mPowerMonitor.setSourceEventListener(null);
    }

    public class SourceEventProcessor
    implements Listener<SourceEvent> {
        @Override
        public void receive(SourceEvent sourceEvent) {
            if (sourceEvent.getEvent() == SourceEvent.Event.NOTIFICATION_SAMPLE_RATE_CHANGE) {
                double sampleRate = sourceEvent.getValue().doubleValue();
                int decimationRate = 0;
                double decimatedSampleRate = sampleRate;
                if (sampleRate / 2.0 >= FMDemodulatorModule.this.mChannelBandwidth * 2.0) {
                    decimationRate = 2;
                    while (sampleRate / (double)decimationRate / 2.0 >= FMDemodulatorModule.this.mChannelBandwidth * 2.0) {
                        decimationRate *= 2;
                    }
                }
                if (decimationRate > 0) {
                    decimatedSampleRate /= (double)decimationRate;
                }
                FMDemodulatorModule.this.mIDecimationFilter = DecimationFilterFactory.getRealDecimationFilter(decimationRate);
                FMDemodulatorModule.this.mQDecimationFilter = DecimationFilterFactory.getRealDecimationFilter(decimationRate);
                if (decimatedSampleRate < 2.0 * FMDemodulatorModule.this.mChannelBandwidth) {
                    throw new IllegalStateException("FM demodulator with channel bandwidth [" + FMDemodulatorModule.this.mChannelBandwidth + "] requires a channel sample rate of [" + 2.0 * FMDemodulatorModule.this.mChannelBandwidth + "] - sample rate of [" + decimatedSampleRate + "] is not supported");
                }
                int passBandStop = (int)(FMDemodulatorModule.this.mChannelBandwidth * 0.8);
                int stopBandStart = (int)FMDemodulatorModule.this.mChannelBandwidth;
                float[] coefficients = null;
                FIRFilterSpecification specification = FIRFilterSpecification.lowPassBuilder().sampleRate(decimatedSampleRate * 2.0).gridDensity(16).oddLength(true).passBandCutoff(passBandStop).passBandAmplitude(1.0).passBandRipple(0.01).stopBandStart(stopBandStart).stopBandAmplitude(0.0).stopBandRipple(0.005).build();
                try {
                    coefficients = FilterFactory.getTaps(specification);
                }
                catch (FilterDesignException fde) {
                    mLog.error("Couldn't design demodulator remez filter for sample rate [" + sampleRate + "] pass frequency [" + passBandStop + "] and stop frequency [" + stopBandStart + "] - will proceed using sinc (low-pass) filter");
                }
                if (coefficients == null) {
                    mLog.info("Unable to use remez filter designer for sample rate [" + decimatedSampleRate + "] pass band stop [" + passBandStop + "] and stop band start [" + stopBandStart + "] - will proceed using simple low pass filter design");
                    coefficients = FilterFactory.getLowPass(decimatedSampleRate, passBandStop, stopBandStart, 60, WindowType.HAMMING, true);
                }
                FMDemodulatorModule.this.mIBasebandFilter = FilterFactory.getRealFilter(coefficients);
                FMDemodulatorModule.this.mQBasebandFilter = FilterFactory.getRealFilter(coefficients);
                FMDemodulatorModule.this.mResampler = new RealResampler(decimatedSampleRate, 8000.0, 4192, 512);
                FMDemodulatorModule.this.mResampler.setListener(resampled -> FMDemodulatorModule.this.broadcast((float[])resampled));
            }
        }
    }
}

