/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.passport;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.MessageType;
import io.github.dsheirer.module.decode.passport.PassportMessage;
import io.github.dsheirer.sample.Listener;
import java.util.HashMap;
import java.util.Map;

public class PassportMessageProcessor
implements Listener<CorrectedBinaryMessage> {
    private Listener<IMessage> mMessageListener;
    private IdleMessageFinder mIdleFinder = new IdleMessageFinder();
    private PassportMessage mIdleMessage;

    @Override
    public void receive(CorrectedBinaryMessage buffer) {
        if (this.mMessageListener != null) {
            PassportMessage message;
            if (this.mIdleMessage != null) {
                message = new PassportMessage(buffer, this.mIdleMessage);
            } else {
                message = new PassportMessage(buffer);
                this.mIdleFinder.receive(message);
            }
            if (message.isValid()) {
                this.mMessageListener.receive(message);
            }
        }
    }

    public void setMessageListener(Listener<IMessage> listener) {
        this.mMessageListener = listener;
    }

    public void removeMessageListener() {
        this.mMessageListener = null;
    }

    public class IdleMessageFinder {
        public Map<String, Integer> mMessageCounts = new HashMap<String, Integer>();
        public boolean mIdleMessageFound = false;

        public void receive(PassportMessage message) {
            if (!this.mIdleMessageFound && message.isValid() && message.getMessageType() == MessageType.SY_IDLE) {
                if (this.mMessageCounts.containsKey(message.toString())) {
                    int count = this.mMessageCounts.get(message.toString());
                    if (count >= 3) {
                        this.mIdleMessageFound = true;
                        PassportMessageProcessor.this.mIdleMessage = message;
                        this.mMessageCounts = null;
                    } else {
                        this.mMessageCounts.put(message.toString(), ++count);
                    }
                } else {
                    this.mMessageCounts.put(message.toString(), 1);
                }
            }
        }
    }
}

