/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.passport;

import io.github.dsheirer.channel.state.DecoderState;
import io.github.dsheirer.channel.state.DecoderStateEvent;
import io.github.dsheirer.channel.state.State;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.identifier.IdentifierClass;
import io.github.dsheirer.identifier.IdentifierCollection;
import io.github.dsheirer.identifier.Role;
import io.github.dsheirer.identifier.decoder.DecoderLogicalChannelNameIdentifier;
import io.github.dsheirer.message.IMessage;
import io.github.dsheirer.message.MessageType;
import io.github.dsheirer.module.decode.DecoderType;
import io.github.dsheirer.module.decode.event.DecodeEvent;
import io.github.dsheirer.module.decode.event.DecodeEventType;
import io.github.dsheirer.module.decode.passport.PassportBand;
import io.github.dsheirer.module.decode.passport.PassportDecodeEvent;
import io.github.dsheirer.module.decode.passport.PassportMessage;
import io.github.dsheirer.module.decode.passport.identifier.PassportRadioId;
import io.github.dsheirer.module.decode.passport.identifier.PassportTalkgroup;
import io.github.dsheirer.protocol.Protocol;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PassportDecoderState
extends DecoderState {
    private static final Logger mLog = LoggerFactory.getLogger(PassportDecoderState.class);
    private Set<PassportTalkgroup> mTalkgroupsFirstHeard = new HashSet<PassportTalkgroup>();
    private Set<PassportTalkgroup> mTalkgroups = new TreeSet<PassportTalkgroup>();
    private Set<PassportRadioId> mMobileIDs = new TreeSet<PassportRadioId>();
    private Map<Integer, Long> mSiteLCNs = new HashMap<Integer, Long>();
    private Map<Integer, Long> mNeighborLCNs = new HashMap<Integer, Long>();
    private Map<Integer, DecodeEvent> mDetectedCalls = new HashMap<Integer, DecodeEvent>();
    private DecodeEvent mCurrentDecodeEvent;
    private int mChannelNumber;
    private int mSiteNumber;
    private PassportBand mSiteBand;
    private long mFrequency;

    @Override
    public DecoderType getDecoderType() {
        return DecoderType.PASSPORT;
    }

    private void addTalkgroup(PassportTalkgroup talkgroup) {
        if (this.mTalkgroupsFirstHeard.contains(talkgroup)) {
            this.mTalkgroups.add(talkgroup);
        } else {
            this.mTalkgroupsFirstHeard.add(talkgroup);
        }
    }

    private boolean isSameTalkgroup(Identifier id1, Identifier id2) {
        return Objects.equals(id1, id2);
    }

    private Identifier getToIdentifier(IdentifierCollection collection) {
        List<Identifier> identifiers = collection.getIdentifiers(Role.TO);
        if (identifiers.size() >= 1) {
            return identifiers.get(0);
        }
        return null;
    }

    @Override
    public void receive(IMessage message) {
        PassportMessage passport;
        if (message instanceof PassportMessage && message.isValid() && (passport = (PassportMessage)message).isValid()) {
            switch (passport.getMessageType()) {
                case CA_STRT: 
                case DA_STRT: {
                    this.mSiteLCNs.put(passport.getLCN(), passport.getLCNFrequency());
                    PassportTalkgroup to = passport.getToIdentifier();
                    this.addTalkgroup(to);
                    if (this.mChannelNumber == 0) {
                        this.setChannelNumber(passport.getLCN());
                    }
                    if (passport.getLCN() == this.mChannelNumber) {
                        this.getIdentifierCollection().update(to);
                        if (this.mCurrentDecodeEvent != null) {
                            if (this.isSameTalkgroup(this.getToIdentifier(this.mCurrentDecodeEvent.getIdentifierCollection()), to)) {
                                this.mCurrentDecodeEvent.update(passport.getTimestamp());
                                this.broadcast(this.mCurrentDecodeEvent);
                                this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.CALL));
                                return;
                            }
                            this.mCurrentDecodeEvent.end(message.getTimestamp());
                            this.broadcast(this.mCurrentDecodeEvent);
                            this.mCurrentDecodeEvent = null;
                        }
                        DecodeEventType decodeEventType = passport.getMessageType() == MessageType.CA_STRT ? DecodeEventType.CALL : DecodeEventType.DATA_CALL;
                        this.mCurrentDecodeEvent = PassportDecodeEvent.builder(decodeEventType, passport.getTimestamp()).identifiers(this.getIdentifierCollection().copyOf()).details(passport.toString()).build();
                        this.broadcast(this.mCurrentDecodeEvent);
                        this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.START, State.CALL));
                        break;
                    }
                    int lcn = passport.getLCN();
                    DecodeEvent callDetect = this.mDetectedCalls.get(lcn);
                    if (callDetect == null || !this.isSameTalkgroup(to, this.getToIdentifier(callDetect.getIdentifierCollection())) || callDetect.getTimeStart() < passport.getTimestamp() - 45000L) {
                        callDetect = PassportDecodeEvent.builder(DecodeEventType.CALL_DETECT, passport.getTimestamp()).identifiers(new IdentifierCollection(passport.getIdentifiers())).build();
                        this.mDetectedCalls.put(lcn, callDetect);
                    } else {
                        callDetect.update(passport.getTimestamp());
                    }
                    this.broadcast(callDetect);
                    break;
                }
                case CA_ENDD: 
                case DA_ENDD: {
                    PassportTalkgroup endTalkgroup = passport.getToIdentifier();
                    this.addTalkgroup(endTalkgroup);
                    if (this.mCurrentDecodeEvent != null && this.isSameTalkgroup(endTalkgroup, this.getToIdentifier(this.mCurrentDecodeEvent.getIdentifierCollection()))) {
                        this.mCurrentDecodeEvent.end(passport.getTimestamp());
                        this.mCurrentDecodeEvent = null;
                    }
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.END, State.CALL));
                    break;
                }
                case ID_RDIO: {
                    PassportRadioId mobileId = passport.getFromIdentifier();
                    this.mMobileIDs.add(mobileId);
                    this.getIdentifierCollection().update(mobileId);
                    if (this.mCurrentDecodeEvent == null) break;
                    this.mCurrentDecodeEvent.setIdentifierCollection(this.getIdentifierCollection().copyOf());
                    this.mCurrentDecodeEvent.update(passport.getTimestamp());
                    this.broadcast(this.mCurrentDecodeEvent);
                    break;
                }
                case RA_REGI: {
                    this.broadcast(PassportDecodeEvent.builder(DecodeEventType.REGISTER, passport.getTimestamp()).identifiers(new IdentifierCollection(passport.getIdentifiers())).build());
                    this.broadcast(new DecoderStateEvent(this, DecoderStateEvent.Event.CONTINUATION, State.DATA));
                    break;
                }
                case SY_IDLE: {
                    if (passport.getFree() != 0) {
                        this.mNeighborLCNs.put(passport.getFree(), passport.getFreeFrequency());
                    }
                    this.setSiteNumber(passport.getSite());
                    PassportBand band = passport.getSiteBand();
                    this.setSiteBand(band);
                    this.setChannelNumber(this.getSiteBand().getChannel(this.mFrequency));
                    break;
                }
            }
        }
    }

    @Override
    public String getActivitySummary() {
        StringBuilder sb = new StringBuilder();
        sb.append("Activity Summary\n");
        sb.append("Decoder:\tPassport\n\n");
        sb.append("Site Channels\n");
        if (this.mSiteLCNs.isEmpty()) {
            sb.append("  None\n");
        } else {
            this.mSiteLCNs.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                sb.append("  " + String.valueOf(entry.getKey()));
                sb.append("\t" + String.valueOf(entry.getValue()));
                sb.append("\n");
            });
        }
        sb.append("\nNeighbor Channels\n");
        if (this.mNeighborLCNs.isEmpty()) {
            sb.append("  None\n");
        } else {
            this.mNeighborLCNs.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
                sb.append("  " + String.valueOf(entry.getKey()));
                sb.append("\t" + String.valueOf(entry.getValue()));
                sb.append("\n");
            });
        }
        sb.append("\nTalkgroups\n");
        if (this.mTalkgroups.isEmpty()) {
            sb.append("  None\n");
        } else {
            for (PassportTalkgroup mTalkgroup : this.mTalkgroups) {
                sb.append("  ").append(mTalkgroup).append("\n");
            }
        }
        sb.append("\nMobile ID Numbers\n");
        if (this.mMobileIDs.isEmpty()) {
            sb.append("  None\n");
        } else {
            for (PassportRadioId mMobileID : this.mMobileIDs) {
                sb.append("  ").append(mMobileID).append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public void reset() {
        super.reset();
        this.getIdentifierCollection().remove(IdentifierClass.USER);
        this.mTalkgroupsFirstHeard.clear();
        this.mTalkgroups.clear();
        this.mMobileIDs.clear();
        this.mSiteLCNs.clear();
        this.mNeighborLCNs.clear();
        this.resetState();
    }

    @Override
    public void start() {
    }

    @Override
    public void stop() {
    }

    @Override
    public void init() {
    }

    @Override
    protected void resetState() {
        super.resetState();
        if (this.mCurrentDecodeEvent != null) {
            this.mCurrentDecodeEvent.end(System.currentTimeMillis());
            this.mCurrentDecodeEvent = null;
        }
    }

    public int getChannelNumber() {
        return this.mChannelNumber;
    }

    private void setChannelNumber(int channel) {
        if (this.mChannelNumber != channel) {
            this.mChannelNumber = channel;
            this.getIdentifierCollection().update(DecoderLogicalChannelNameIdentifier.create(String.valueOf(this.mChannelNumber), Protocol.PASSPORT));
        }
    }

    public int getSiteNumber() {
        return this.mSiteNumber;
    }

    private void setSiteNumber(int site) {
        if (this.mSiteNumber != site) {
            this.mSiteNumber = site;
        }
    }

    private PassportBand getSiteBand() {
        return this.mSiteBand;
    }

    private void setSiteBand(PassportBand band) {
        if (this.mSiteBand == null) {
            this.mSiteBand = band;
        }
    }

    @Override
    public void receiveDecoderStateEvent(DecoderStateEvent event) {
        switch (event.getEvent()) {
            case REQUEST_RESET: {
                this.resetState();
                break;
            }
            case NOTIFICATION_SOURCE_FREQUENCY: {
                this.mFrequency = event.getFrequency();
                break;
            }
        }
    }
}

