/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.passport;

import org.apache.commons.math3.util.FastMath;

public enum PassportBand {
    BAND_800("800", 800000000),
    BAND_900("900", 900000000),
    BAND_400("400", 400000000),
    BAND_420("420", 420000000),
    BAND_440("440", 440000000),
    BAND_450("450", 450000000),
    BAND_460("460", 460000000),
    BAND_470("470", 470000000),
    BAND_480("480", 480000000),
    BAND_490("490", 490000000),
    BAND_CANADA("CAN", 0),
    BAND_NTIA("NTIA", 0),
    BAND_RESERVED12("RESVD", 0),
    BAND_216("216", 216000000),
    BAND_RESERVED14("RESVD", 0),
    BAND_700("700", 700000000),
    BAND_VHF("VHF", 0),
    BAND_UNKNOWN("UNK", 0);

    public static int CHANNEL_BANDWIDTH;
    private String mDescription;
    private int mBase;

    private PassportBand(String description, int base) {
        this.mDescription = description;
        this.mBase = base;
    }

    public static PassportBand lookup(int band) {
        if (band >= 0 && band < 16) {
            return PassportBand.values()[band];
        }
        return BAND_UNKNOWN;
    }

    public long getFrequency(int channel) {
        return this.mBase + channel * CHANNEL_BANDWIDTH;
    }

    public int getChannel(long frequency) {
        return FastMath.round((float)((float)(frequency - (long)this.mBase) / (float)CHANNEL_BANDWIDTH));
    }

    public String getDescription() {
        return this.mDescription;
    }

    public int getBase() {
        return this.mBase;
    }

    static {
        CHANNEL_BANDWIDTH = 12500;
    }
}

