/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.reference;

import java.util.ArrayList;
import java.util.List;

public class SystemServiceClass {
    private static final int NO_SERVICES = 0;
    private static final int COMPOSITE_CONTROL_CHANNEL = 1;
    private static final int NO_SERVICE_REQUESTS = 2;
    private static final int BACKUP_CONTROL_CHANNEL = 4;
    private static final int DATA_SERVICE = 16;
    private static final int VOICE_SERVICE = 32;
    private static final int REGISTRATION_SERVICE = 64;
    private static final int AUTHENTICATION_SERVICE = 128;
    private int mSystemServiceClass;

    public SystemServiceClass(int systemServiceClass) {
        this.mSystemServiceClass = systemServiceClass;
    }

    public List<String> getServices() {
        ArrayList<String> services = new ArrayList<String>();
        if (this.hasFlag(16)) {
            services.add("DATA");
        }
        if (this.hasFlag(32)) {
            services.add("VOICE");
        }
        if (this.hasFlag(64)) {
            services.add("REGISTRATION");
        }
        if (this.hasFlag(128)) {
            services.add("AUTHENTICATION");
        }
        if (this.hasFlag(1)) {
            services.add("COMPOSITE CONTROL CHANNEL");
        }
        if (this.hasFlag(2)) {
            services.add("NO SERVICE REQUESTS");
        }
        if (this.hasFlag(4)) {
            services.add("BACKUP CONTROL CHANNEL");
        }
        return services;
    }

    private boolean hasFlag(int flag) {
        return (this.mSystemServiceClass & flag) == flag;
    }

    public String toString() {
        return this.getServices().toString();
    }

    public static SystemServiceClass create(int systemServiceClass) {
        return new SystemServiceClass(systemServiceClass);
    }
}

