/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.reference;

public enum QueuedResponseReason {
    RESERVED(0),
    REQUESTING_UNIT_BUSY_OTHER_SERVICE(16),
    TARGET_UNIT_BUSY_OTHER_SERVICE(32),
    TARGET_UNIT_QUEUED_THIS_CALL(47),
    TARGET_GROUP_CURRENTLY_ACTIVE(48),
    CHANNEL_RESOURCES_UNAVAILABLE(64),
    TELEPHONE_RESOURCES_UNAVAILABLE(65),
    DATA_RESOURCES_UNAVAILABLE(66),
    SUPERSEDING_SERVICE_CURRENTLY_ACTIVE(80),
    USER_OR_SYSTEM_DEFINED(128),
    UNKNOWN(-1);

    private int mCode;

    private QueuedResponseReason(int code) {
        this.mCode = code;
    }

    public static QueuedResponseReason fromCode(int code) {
        if (code == 16) {
            return REQUESTING_UNIT_BUSY_OTHER_SERVICE;
        }
        if (code == 32) {
            return TARGET_UNIT_BUSY_OTHER_SERVICE;
        }
        if (code == 47) {
            return TARGET_UNIT_QUEUED_THIS_CALL;
        }
        if (code == 48) {
            return TARGET_GROUP_CURRENTLY_ACTIVE;
        }
        if (code == 64) {
            return CHANNEL_RESOURCES_UNAVAILABLE;
        }
        if (code == 65) {
            return TELEPHONE_RESOURCES_UNAVAILABLE;
        }
        if (code == 66) {
            return DATA_RESOURCES_UNAVAILABLE;
        }
        if (code == 80) {
            return SUPERSEDING_SERVICE_CURRENTLY_ACTIVE;
        }
        if (code <= 127) {
            return RESERVED;
        }
        if (code >= 128) {
            return USER_OR_SYSTEM_DEFINED;
        }
        return UNKNOWN;
    }
}

