/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.reference;

public class Capability {
    private static int VALID_FLAG = 64;
    private static int TDMA_HALF_RATE_2_SLOT_FLAG = 32;
    private static int TDMA_HALF_RATE_4_SLOT_FLAG = 16;
    private static int FDMA_HALF_RATE_FLAG = 8;
    private static int TDMA_8PSK_FLAG = 4;
    private int mCapability;

    public Capability(int capability) {
        this.mCapability = capability;
    }

    public boolean isValid() {
        return (this.mCapability & VALID_FLAG) == VALID_FLAG;
    }

    public boolean isTDMAHalfRate2Slot() {
        return this.isValid() && (this.mCapability & TDMA_HALF_RATE_2_SLOT_FLAG) == TDMA_HALF_RATE_2_SLOT_FLAG;
    }

    public boolean isTDMAHalfRate4Slot() {
        return this.isValid() && (this.mCapability & TDMA_HALF_RATE_4_SLOT_FLAG) == TDMA_HALF_RATE_4_SLOT_FLAG;
    }

    public boolean isFDMAHalfRate() {
        return this.isValid() && (this.mCapability & FDMA_HALF_RATE_FLAG) == FDMA_HALF_RATE_FLAG;
    }

    public boolean isTDMA8PSK() {
        return this.isValid() && (this.mCapability & TDMA_8PSK_FLAG) == TDMA_8PSK_FLAG;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FDMA/FULL-RATE");
        if (this.isFDMAHalfRate()) {
            sb.append("/HALF-RATE");
        }
        if (this.isTDMAHalfRate2Slot() || this.isTDMAHalfRate4Slot() || this.isTDMA8PSK()) {
            sb.append(" TDMA");
            if (this.isTDMAHalfRate2Slot() || this.isTDMAHalfRate4Slot()) {
                sb.append("/HALF-RATE");
            }
            if (this.isTDMAHalfRate2Slot()) {
                sb.append("/2-SLOT");
            }
            if (this.isTDMAHalfRate4Slot()) {
                sb.append("/4-SLOT");
            }
            if (this.isTDMA8PSK()) {
                sb.append("/8PSK");
            }
        }
        return sb.toString();
    }
}

