/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.timeslot;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.DataUnitID;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.AbstractVoiceTimeslot;
import java.util.ArrayList;
import java.util.List;

public class Voice2Timeslot
extends AbstractVoiceTimeslot {
    private static final int FRAME_LENGTH = 72;
    private static final int FRAME_1_START = 2;
    private static final int FRAME_2_START = 76;
    private static final int ESS_A1_START = 148;
    private static final int ESS_A1_LENGTH = 96;
    private static final int ESS_A2_START = 246;
    private static final int ESS_A2_LENGTH = 72;
    private List<BinaryMessage> mVoiceFrames;
    private BinaryMessage mEssA;

    public Voice2Timeslot(CorrectedBinaryMessage message, BinaryMessage scramblingSequence, int timeslot, long timestamp) {
        super(message, DataUnitID.VOICE_2, scramblingSequence, timeslot, timestamp);
    }

    @Override
    public List<BinaryMessage> getVoiceFrames() {
        if (this.mVoiceFrames == null) {
            this.mVoiceFrames = new ArrayList<BinaryMessage>();
            this.mVoiceFrames.add(this.getMessage().getSubMessage(2, 74));
            this.mVoiceFrames.add(this.getMessage().getSubMessage(76, 148));
            return this.mVoiceFrames;
        }
        return this.mVoiceFrames;
    }

    public BinaryMessage getEssA() {
        if (this.mEssA == null) {
            CorrectedBinaryMessage segment1 = this.getMessage().getSubMessage(148, 244);
            CorrectedBinaryMessage segment2 = this.getMessage().getSubMessage(246, 318);
            this.mEssA = new BinaryMessage(168);
            this.mEssA.load(0, segment1);
            this.mEssA.load(96, segment2);
        }
        return this.mEssA;
    }
}

