/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.timeslot;

import io.github.dsheirer.bits.BinaryMessage;
import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.edac.ReedSolomon_63_35_29_P25;
import io.github.dsheirer.module.decode.p25.phase2.enumeration.DataUnitID;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacMessage;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacMessageFactory;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.UnknownMacMessage;
import io.github.dsheirer.module.decode.p25.phase2.timeslot.AbstractSignalingTimeslot;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FacchTimeslot
extends AbstractSignalingTimeslot {
    private static final Logger mLog = LoggerFactory.getLogger(FacchTimeslot.class);
    private static final int[] INFO_1 = new int[]{2, 3, 4, 5, 6, 7};
    private static final int[] INFO_2 = new int[]{8, 9, 10, 11, 12, 13};
    private static final int[] INFO_3 = new int[]{14, 15, 16, 17, 18, 19};
    private static final int[] INFO_4 = new int[]{20, 21, 22, 23, 24, 25};
    private static final int[] INFO_5 = new int[]{26, 27, 28, 29, 30, 31};
    private static final int[] INFO_6 = new int[]{32, 33, 34, 35, 36, 37};
    private static final int[] INFO_7 = new int[]{38, 39, 40, 41, 42, 43};
    private static final int[] INFO_8 = new int[]{44, 45, 46, 47, 48, 49};
    private static final int[] INFO_9 = new int[]{50, 51, 52, 53, 54, 55};
    private static final int[] INFO_10 = new int[]{56, 57, 58, 59, 60, 61};
    private static final int[] INFO_11 = new int[]{62, 63, 64, 65, 66, 67};
    private static final int[] INFO_12 = new int[]{68, 69, 70, 71, 72, 73};
    private static final int[] INFO_13 = new int[]{76, 77, 78, 79, 80, 81};
    private static final int[] INFO_14 = new int[]{82, 83, 84, 85, 86, 87};
    private static final int[] INFO_15 = new int[]{88, 89, 90, 91, 92, 93};
    private static final int[] INFO_16 = new int[]{94, 95, 96, 97, 98, 99};
    private static final int[] INFO_17 = new int[]{100, 101, 102, 103, 104, 105};
    private static final int[] INFO_18 = new int[]{106, 107, 108, 109, 110, 111};
    private static final int[] INFO_19 = new int[]{112, 113, 114, 115, 116, 117};
    private static final int[] INFO_20 = new int[]{118, 119, 120, 121, 122, 123};
    private static final int[] INFO_21 = new int[]{124, 125, 126, 127, 128, 129};
    private static final int[] INFO_22 = new int[]{130, 131, 132, 133, 134, 135};
    private static final int[] INFO_23 = new int[]{136, 137, 180, 181, 182, 183};
    private static final int[] INFO_24 = new int[]{184, 185, 186, 187, 188, 189};
    private static final int[] INFO_25 = new int[]{190, 191, 192, 193, 194, 195};
    private static final int[] INFO_26 = new int[]{196, 197, 198, 199, 200, 201};
    private static final int[] PARITY_1 = new int[]{202, 203, 204, 205, 206, 207};
    private static final int[] PARITY_2 = new int[]{208, 209, 210, 211, 212, 213};
    private static final int[] PARITY_3 = new int[]{214, 215, 216, 217, 218, 219};
    private static final int[] PARITY_4 = new int[]{220, 221, 222, 223, 224, 225};
    private static final int[] PARITY_5 = new int[]{226, 227, 228, 229, 230, 231};
    private static final int[] PARITY_6 = new int[]{232, 233, 234, 235, 236, 237};
    private static final int[] PARITY_7 = new int[]{238, 239, 240, 241, 242, 243};
    private static final int[] PARITY_8 = new int[]{246, 247, 248, 249, 250, 251};
    private static final int[] PARITY_9 = new int[]{252, 253, 254, 255, 256, 257};
    private static final int[] PARITY_10 = new int[]{258, 259, 260, 261, 262, 263};
    private static final int[] PARITY_11 = new int[]{264, 265, 266, 267, 268, 269};
    private static final int[] PARITY_12 = new int[]{270, 271, 272, 273, 274, 275};
    private static final int[] PARITY_13 = new int[]{276, 277, 278, 279, 280, 281};
    private static final int[] PARITY_14 = new int[]{282, 283, 284, 285, 286, 287};
    private static final int[] PARITY_15 = new int[]{288, 289, 290, 291, 292, 293};
    private static final int[] PARITY_16 = new int[]{294, 295, 296, 297, 298, 299};
    private static final int[] PARITY_17 = new int[]{300, 301, 302, 303, 304, 305};
    private static final int[] PARITY_18 = new int[]{306, 307, 308, 309, 310, 311};
    private static final int[] PARITY_19 = new int[]{312, 313, 314, 315, 316, 317};
    private List<MacMessage> mMacMessages;

    public FacchTimeslot(CorrectedBinaryMessage message, BinaryMessage scramblingSequence, int timeslot, long timestamp) {
        super(message, DataUnitID.SCRAMBLED_FACCH, scramblingSequence, timeslot, timestamp);
    }

    public FacchTimeslot(CorrectedBinaryMessage message, int timeslot, long timestamp) {
        super(message, DataUnitID.UNSCRAMBLED_FACCH, timeslot, timestamp);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TS").append(this.getTimeslot());
        if (this.getDataUnitID() == DataUnitID.UNSCRAMBLED_FACCH) {
            sb.append(" FA-UN");
            sb.append(" ").append(this.getMacMessages().toString());
        } else {
            sb.append(" FA-SC");
            sb.append(" SCRAMBLED:").append(this.getMessage().toHexString());
        }
        return sb.toString();
    }

    @Override
    public List<MacMessage> getMacMessages() {
        if (this.mMacMessages == null) {
            int x;
            boolean irrecoverableErrors;
            int[] input = new int[63];
            int[] output = new int[63];
            input[9] = this.getMessage().getInt(PARITY_19);
            input[10] = this.getMessage().getInt(PARITY_18);
            input[11] = this.getMessage().getInt(PARITY_17);
            input[12] = this.getMessage().getInt(PARITY_16);
            input[13] = this.getMessage().getInt(PARITY_15);
            input[14] = this.getMessage().getInt(PARITY_14);
            input[15] = this.getMessage().getInt(PARITY_13);
            input[16] = this.getMessage().getInt(PARITY_12);
            input[17] = this.getMessage().getInt(PARITY_11);
            input[18] = this.getMessage().getInt(PARITY_10);
            input[19] = this.getMessage().getInt(PARITY_9);
            input[20] = this.getMessage().getInt(PARITY_8);
            input[21] = this.getMessage().getInt(PARITY_7);
            input[22] = this.getMessage().getInt(PARITY_6);
            input[23] = this.getMessage().getInt(PARITY_5);
            input[24] = this.getMessage().getInt(PARITY_4);
            input[25] = this.getMessage().getInt(PARITY_3);
            input[26] = this.getMessage().getInt(PARITY_2);
            input[27] = this.getMessage().getInt(PARITY_1);
            input[28] = this.getMessage().getInt(INFO_26);
            input[29] = this.getMessage().getInt(INFO_25);
            input[30] = this.getMessage().getInt(INFO_24);
            input[27] = this.getMessage().getInt(INFO_23);
            input[32] = this.getMessage().getInt(INFO_22);
            input[33] = this.getMessage().getInt(INFO_21);
            input[34] = this.getMessage().getInt(INFO_20);
            input[35] = this.getMessage().getInt(INFO_19);
            input[36] = this.getMessage().getInt(INFO_18);
            input[37] = this.getMessage().getInt(INFO_17);
            input[38] = this.getMessage().getInt(INFO_16);
            input[39] = this.getMessage().getInt(INFO_15);
            input[40] = this.getMessage().getInt(INFO_14);
            input[41] = this.getMessage().getInt(INFO_13);
            input[42] = this.getMessage().getInt(INFO_12);
            input[43] = this.getMessage().getInt(INFO_11);
            input[44] = this.getMessage().getInt(INFO_10);
            input[45] = this.getMessage().getInt(INFO_9);
            input[46] = this.getMessage().getInt(INFO_8);
            input[47] = this.getMessage().getInt(INFO_7);
            input[48] = this.getMessage().getInt(INFO_6);
            input[49] = this.getMessage().getInt(INFO_5);
            input[50] = this.getMessage().getInt(INFO_4);
            input[51] = this.getMessage().getInt(INFO_3);
            input[52] = this.getMessage().getInt(INFO_2);
            input[53] = this.getMessage().getInt(INFO_1);
            ReedSolomon_63_35_29_P25 reedSolomon_63_35_29 = new ReedSolomon_63_35_29_P25();
            try {
                irrecoverableErrors = reedSolomon_63_35_29.decode(input, output);
            }
            catch (Exception e) {
                irrecoverableErrors = true;
                mLog.error("Error", (Throwable)e);
            }
            CorrectedBinaryMessage binaryMessage = new CorrectedBinaryMessage(156);
            int pointer = 0;
            for (x = 53; x >= 28; --x) {
                if (output[x] != -1) {
                    binaryMessage.load(pointer, 6, output[x]);
                }
                pointer += 6;
            }
            this.mMacMessages = MacMessageFactory.create(this.getTimeslot(), this.getDataUnitID(), binaryMessage, this.getTimestamp());
            if (irrecoverableErrors) {
                this.mMacMessages.clear();
                UnknownMacMessage macMessage = new UnknownMacMessage(this.getTimeslot(), this.getDataUnitID(), binaryMessage, this.getTimestamp());
                macMessage.setValid(false);
                this.mMacMessages.add(macMessage);
            } else {
                for (x = 9; x <= 53; ++x) {
                    if (output[x] == input[x]) continue;
                    binaryMessage.incrementCorrectedBitCount(Integer.bitCount(output[x] ^ input[x]));
                }
            }
        }
        return this.mMacMessages;
    }
}

