/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.Service;
import java.util.Collections;
import java.util.List;

public class SystemServiceBroadcast
extends MacStructure {
    private static final int[] TWUID_VALIDITY = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] AVAILABLE_SERVICES = new int[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] SUPPORTED_SERVICES = new int[]{40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] REQUEST_PRIORITY_LEVEL = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private List<Service> mAvailableServices;
    private List<Service> mSupportedServices;

    public SystemServiceBroadcast(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" AVAILABLE SERVICES ").append(this.getAvailableServices());
        sb.append(" SUPPORTED SERVICES ").append(this.getSupportedServices());
        return sb.toString();
    }

    public List<Service> getAvailableServices() {
        if (this.mAvailableServices == null) {
            this.mAvailableServices = Service.getServices(this.getMessage().getInt(AVAILABLE_SERVICES, this.getOffset()));
        }
        return this.mAvailableServices;
    }

    public List<Service> getSupportedServices() {
        if (this.mSupportedServices == null) {
            this.mSupportedServices = Service.getServices(this.getMessage().getInt(SUPPORTED_SERVICES, this.getOffset()));
        }
        return this.mSupportedServices;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        return Collections.EMPTY_LIST;
    }
}

