/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25FullyQualifiedRadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.radio.APCO25RadioIdentifier;
import io.github.dsheirer.module.decode.p25.identifier.status.APCO25UnitStatus;
import io.github.dsheirer.module.decode.p25.identifier.status.APCO25UserStatus;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import java.util.ArrayList;
import java.util.List;

public class StatusUpdateExtended
extends MacStructure {
    private static final int[] UNIT_STATUS = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] USER_STATUS = new int[]{24, 25, 26, 27, 28, 29, 30, 31};
    private static final int[] TARGET_ADDRESS = new int[]{32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55};
    private static final int[] SOURCE_WACN = new int[]{56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75};
    private static final int[] SOURCE_SYSTEM = new int[]{76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87};
    private static final int[] SOURCE_ADDRESS = new int[]{88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111};
    private List<Identifier> mIdentifiers;
    private Identifier mUnitStatus;
    private Identifier mUserStatus;
    private Identifier mTargetAddress;
    private APCO25FullyQualifiedRadioIdentifier mSourceSuid;

    public StatusUpdateExtended(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" FM:").append(this.getSourceSuid());
        sb.append(" TO:").append(this.getTargetAddress());
        sb.append(" UNIT:").append(this.getUnitStatus());
        sb.append(" USER:").append(this.getUserStatus());
        return sb.toString();
    }

    public Identifier getUnitStatus() {
        if (this.mUnitStatus == null) {
            this.mUnitStatus = APCO25UnitStatus.create(this.getMessage().getInt(UNIT_STATUS));
        }
        return this.mUnitStatus;
    }

    public Identifier getUserStatus() {
        if (this.mUserStatus == null) {
            this.mUserStatus = APCO25UserStatus.create(this.getMessage().getInt(USER_STATUS));
        }
        return this.mUserStatus;
    }

    public Identifier getTargetAddress() {
        if (this.mTargetAddress == null) {
            this.mTargetAddress = APCO25RadioIdentifier.createTo(this.getMessage().getInt(TARGET_ADDRESS, this.getOffset()));
        }
        return this.mTargetAddress;
    }

    public Identifier getSourceSuid() {
        if (this.mSourceSuid == null) {
            this.mSourceSuid = APCO25FullyQualifiedRadioIdentifier.createFrom(this.getMessage().getInt(SOURCE_WACN, this.getOffset()), this.getMessage().getInt(SOURCE_SYSTEM, this.getOffset()), this.getMessage().getInt(SOURCE_ADDRESS, this.getOffset()));
        }
        return this.mSourceSuid;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getTargetAddress());
            this.mIdentifiers.add(this.getSourceSuid());
            this.mIdentifiers.add(this.getUnitStatus());
            this.mIdentifiers.add(this.getUserStatus());
        }
        return this.mIdentifiers;
    }
}

