/*
 * Decompiled with CFR 0.152.
 */
package io.github.dsheirer.module.decode.p25.phase2.message.mac.structure;

import io.github.dsheirer.bits.CorrectedBinaryMessage;
import io.github.dsheirer.channel.IChannelDescriptor;
import io.github.dsheirer.identifier.Identifier;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Rfss;
import io.github.dsheirer.module.decode.p25.identifier.APCO25Site;
import io.github.dsheirer.module.decode.p25.identifier.channel.APCO25Channel;
import io.github.dsheirer.module.decode.p25.phase1.message.IFrequencyBandReceiver;
import io.github.dsheirer.module.decode.p25.phase2.message.mac.MacStructure;
import io.github.dsheirer.module.decode.p25.reference.SystemServiceClass;
import java.util.ArrayList;
import java.util.List;

public class SecondaryControlChannelBroadcastAbbreviated
extends MacStructure
implements IFrequencyBandReceiver {
    private static final int[] RFSS = new int[]{8, 9, 10, 11, 12, 13, 14, 15};
    private static final int[] SITE = new int[]{16, 17, 18, 19, 20, 21, 22, 23};
    private static final int[] FREQUENCY_BAND_A = new int[]{24, 25, 26, 27};
    private static final int[] CHANNEL_NUMBER_A = new int[]{28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39};
    private static final int[] SYSTEM_SERVICE_CLASS_A = new int[]{40, 41, 42, 43, 44, 45, 46, 47};
    private static final int[] FREQUENCY_BAND_B = new int[]{48, 49, 50, 51};
    private static final int[] CHANNEL_NUMBER_B = new int[]{52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63};
    private static final int[] SYSTEM_SERVICE_CLASS_B = new int[]{64, 65, 66, 67, 68, 69, 70, 71};
    private Identifier mRfss;
    private Identifier mSite;
    private IChannelDescriptor mChannelA;
    private IChannelDescriptor mChannelB;
    private SystemServiceClass mSystemServiceClassA;
    private SystemServiceClass mSystemServiceClassB;
    private List<Identifier> mIdentifiers;

    public SecondaryControlChannelBroadcastAbbreviated(CorrectedBinaryMessage message, int offset) {
        super(message, offset);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append((Object)this.getOpcode());
        sb.append(" RFSS:").append(this.getRfss());
        sb.append(" SITE:").append(this.getSite());
        sb.append(" CHAN A:").append(this.getChannelA());
        sb.append(" SERVICE OPTIONS:").append(this.getSystemServiceClassA());
        if (this.hasChannelB()) {
            sb.append(" CHAN B:").append(this.getChannelB());
            sb.append(" SERVICE OPTIONS:").append(this.getSystemServiceClassB());
        }
        return sb.toString();
    }

    public Identifier getRfss() {
        if (this.mRfss == null) {
            this.mRfss = APCO25Rfss.create(this.getMessage().getInt(RFSS, this.getOffset()));
        }
        return this.mRfss;
    }

    public Identifier getSite() {
        if (this.mSite == null) {
            this.mSite = APCO25Site.create(this.getMessage().getInt(SITE, this.getOffset()));
        }
        return this.mSite;
    }

    public IChannelDescriptor getChannelA() {
        if (this.mChannelA == null) {
            this.mChannelA = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_A, this.getOffset()), this.getMessage().getInt(CHANNEL_NUMBER_A, this.getOffset()));
        }
        return this.mChannelA;
    }

    public SystemServiceClass getSystemServiceClassA() {
        if (this.mSystemServiceClassA == null) {
            this.mSystemServiceClassA = new SystemServiceClass(this.getMessage().getInt(SYSTEM_SERVICE_CLASS_A, this.getOffset()));
        }
        return this.mSystemServiceClassA;
    }

    private boolean hasChannelB() {
        return this.getMessage().getInt(CHANNEL_NUMBER_A, this.getOffset()) != this.getMessage().getInt(CHANNEL_NUMBER_B, this.getOffset()) && this.getMessage().getInt(SYSTEM_SERVICE_CLASS_B, this.getOffset()) != 0;
    }

    public IChannelDescriptor getChannelB() {
        if (this.hasChannelB() && this.mChannelB == null) {
            this.mChannelB = APCO25Channel.create(this.getMessage().getInt(FREQUENCY_BAND_B, this.getOffset()), this.getMessage().getInt(CHANNEL_NUMBER_B, this.getOffset()));
        }
        return this.mChannelB;
    }

    public SystemServiceClass getSystemServiceClassB() {
        if (this.mSystemServiceClassB == null) {
            this.mSystemServiceClassB = new SystemServiceClass(this.getMessage().getInt(SYSTEM_SERVICE_CLASS_B, this.getOffset()));
        }
        return this.mSystemServiceClassB;
    }

    @Override
    public List<Identifier> getIdentifiers() {
        if (this.mIdentifiers == null) {
            this.mIdentifiers = new ArrayList<Identifier>();
            this.mIdentifiers.add(this.getSite());
            this.mIdentifiers.add(this.getRfss());
        }
        return this.mIdentifiers;
    }

    @Override
    public List<IChannelDescriptor> getChannels() {
        ArrayList<IChannelDescriptor> channels = new ArrayList<IChannelDescriptor>();
        channels.add(this.getChannelA());
        if (this.hasChannelB()) {
            channels.add(this.getChannelB());
        }
        return channels;
    }
}

